package eu.dnetlib.data.actionmanager.inspector;

import java.util.List;

import eu.dnetlib.data.actionmanager.blackboard.ActionManagerJobLauncher;
import eu.dnetlib.data.hadoop.HadoopIsClient;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerException;
import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerSet;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Provenance;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ActionManagerController extends AbstractInspectorController {

	@Autowired
	private HadoopIsClient isClient;

	@ModelAttribute(value = "types")
	public ACTION_TYPE[] listActionTypes() {
		return ACTION_TYPE.values();
	}

	@ModelAttribute(value = "provenances")
	public Provenance[] listProvenances() {
		return Provenance.values();
	}

	@ModelAttribute(value = "sets")
	public List<ActionManagerSet> listSets() throws ActionManagerException {
		return isClient.listSets();
	}

	@RequestMapping("/inspector/actions/createSet.do")
	public String createSet(final ModelMap map,
			@RequestParam(value = "id", required = true) final String id,
			@RequestParam(value = "name", required = true) final String name,
			@RequestParam(value = "directory", required = true) final String directory) throws Exception {
		isClient.registerSetProfile(new ActionManagerSet(id, name, directory));
		return "redirect:listSets.do";
	}

	@RequestMapping("/inspector/actions/listSets.do")
	public void createSet(final ModelMap map) throws Exception {
		map.addAttribute("sets", isClient.listValidSets());
	}

	@RequestMapping("/inspector/actions/deleteSet.do")
	public String deleteSet(final ModelMap map, @RequestParam(value = "set", required = true) final String set) throws Exception {
		map.addAttribute("allSets", ActionManagerJobLauncher.ALL_SETS);
		if (set != null && !set.isEmpty()) {
			isClient.deleteSetProfile(set);
		}
		return "redirect:listSets.do";
	}

	@RequestMapping("/inspector/actions/linkActionSetProfile.do")
	public String linkProfile(@RequestParam(value = "set", required = true) final String set) throws Exception {
		if (StringUtils.isBlank(set)) {
			throw new IllegalArgumentException("missing set id");
		}
		final String profileId = isClient.getActionSetProfileId(set);
		return "redirect:/mvc/inspector/index.do/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType/" + profileId + "/show";
	}

}
