package eu.dnetlib.data.hadoop.blackboard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.hadoop.JobRegistry;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class KillJobAction extends AbstractHadoopAction {

	private static final Log log = LogFactory.getLog(KillJobAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private JobRegistry jobRegistry;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob bbJob) {

		final String jobid = bbJob.getParameters().get("job.id");
		log.info("killing job: " + jobid);

		try {
			jobRegistry.unregisterJob(jobid);
			handler.done(bbJob);
		} catch (HadoopServiceException e) {
			handler.failed(bbJob, e);
		}
	}

}
