/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.utils;

import eu.dnetlib.data.hadoop.utils.ScanProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Base64;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Value;

public class ScanFactory {
    private static final Log log = LogFactory.getLog(ScanFactory.class);
    @Value(value="${services.hadoop.hbase.maxversions}")
    private int hbaseMaxVersions;

    public String getScan(ScanProperties scanProperties) throws IOException {
        return ScanFactory.convertScanToString(this.getScanObject(scanProperties));
    }

    public Scan getScanObject(ScanProperties scanProperties) {
        Scan scan = new Scan();
        scan.setCaching(scanProperties.getCaching());
        scan.setCacheBlocks(false);
        scan.setFilter((Filter)scanProperties.getFilterList());
        for (String family : scanProperties.getFamilies()) {
            scan.addFamily(family.getBytes());
        }
        if (scanProperties.getVersions() > 0) {
            log.info((Object)String.format("scanner to read %s versions from hbase", scanProperties.getVersions()));
            scan.setMaxVersions(scanProperties.getVersions());
        }
        return scan;
    }

    public ScanProperties parseScanProperties(Document doc, Map<String, String> bbParams) {
        Node node;
        log.debug((Object)"setting job scanner");
        ScanProperties scanProperties = new ScanProperties(doc.valueOf("//FILTERS/@operator"));
        String caching = doc.valueOf("//SCAN/@caching");
        if (!StringUtils.isBlank((CharSequence)caching)) {
            log.info((Object)("overriding default scan caching with: " + caching));
            scanProperties.setCaching(Integer.valueOf(caching));
        }
        FilterList columnFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        for (Object o : doc.selectNodes("//SCAN/FAMILIES/FAMILY")) {
            String readVersions;
            String qualifier;
            node = (Node)o;
            String value = node.valueOf("./@value");
            if (StringUtils.isBlank((CharSequence)value)) {
                value = bbParams.get(node.valueOf("./@param"));
            }
            if (StringUtils.isNotBlank((CharSequence)(qualifier = node.valueOf("./@qualifier")))) {
                columnFilter.addFilter((Filter)new ColumnPrefixFilter(qualifier.trim().getBytes()));
            }
            if (StringUtils.isNotBlank((CharSequence)(readVersions = node.valueOf("./@readVersions"))) && Boolean.parseBoolean(readVersions)) {
                scanProperties.setVersions(this.hbaseMaxVersions);
            }
            log.debug((Object)String.format("scanner family: '%s', qualifier: '%s', readVersions: '%s'", value, qualifier, readVersions));
            scanProperties.getFamilies().add(value);
        }
        if (!columnFilter.getFilters().isEmpty()) {
            scanProperties.getFilterList().addFilter((Filter)columnFilter);
        }
        for (Object o : doc.selectNodes("//SCAN/FILTERS/FILTER")) {
            node = (Node)o;
            String filterType = node.valueOf("./@type");
            String value = node.valueOf("./@value");
            if (value == null || value.isEmpty()) {
                value = bbParams.get(node.valueOf("./@param"));
            }
            if (value == null) {
                throw new IllegalArgumentException("missing value for Scan filter [entityTypeId|entityType]");
            }
            if (!filterType.equals("prefix")) continue;
            log.debug((Object)("scanner prefix filter, value: " + value));
            scanProperties.getFilterList().addFilter((Filter)new PrefixFilter(value.getBytes()));
        }
        return scanProperties;
    }

    private static String convertScanToString(Scan scan) throws IOException {
        log.debug((Object)"serializing scan");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        scan.write((DataOutput)dos);
        return Base64.encodeBytes((byte[])out.toByteArray());
    }
}

