package eu.dnetlib.data.hadoop.mapreduce;

import java.io.IOException;

import eu.dnetlib.rmi.data.hadoop.ClusterName;
import org.apache.hadoop.mapred.JobClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;

/**
 * Factory bean for jobClient instances
 *
 * @author claudio
 *
 */
public class JobClientFactory {

	@Lazy
	@Autowired
	private ConfigurationEnumerator configurationEnumerator;

	public JobClient newInstance(final String name) throws IOException {
		return new JobClient(configurationEnumerator.get(ClusterName.valueOf(name)));
	}

}
