package eu.dnetlib.data.hadoop.blackboard;

import eu.dnetlib.data.hadoop.HadoopServiceCore;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Creates a directory on hdfs, if it does not exists.
 * <p/>
 * Params - cluster: cluster name, path: directory path to be created, forceDelete: forces the directory to be dropped and recreated.
 *
 * @author claudio
 */
public class CreateHdfsDirectoryAction extends AbstractHadoopAction {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(CreateHdfsDirectoryAction.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * The hadoop service core.
	 */
	@Autowired
	private HadoopServiceCore hadoopServiceCore;

	@Override
	protected void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws HadoopServiceException {

		final ClusterName clusterName = ClusterName.valueOf(job.getParameters().get("cluster"));
		log.info("create directory request on cluster: " + clusterName.toString());

		final boolean forceDelete = isForceDelete(job);
		final String path = job.getParameters().get("path");

		hadoopServiceCore.createHdfsDir(clusterName, path, forceDelete);

		handler.done(job);
	}

	private boolean isForceDelete(final BlackboardJob job) {
		try {
			return Boolean.parseBoolean(job.getParameters().get("force"));
		} catch (IllegalArgumentException e) {
			return false;
		}
	}

}
