/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.hadoop.hbase;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.config.ConfigurationEnumerator;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class HbaseTableFeeder {
    private static final Log log = LogFactory.getLog(HbaseTableFeeder.class);
    @Autowired
    protected ConfigurationEnumerator configurationEnumerator;
    @Autowired
    private ResultSetClient resultSetClient;
    private int batchSize = 100;

    protected abstract void addOperation(List<Mutation> var1, Row var2);

    public int feed(String rsJson, String xsl, ClusterName clusterName, String tableName, boolean simulation) throws IOException, InterruptedException {
        return this.doWrite(this.asRows(rsJson, xsl), this.getConf(clusterName), tableName, simulation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWrite(Iterable<Row> rows, Configuration configuration, String tableName, boolean simulation) throws IOException, InterruptedException {
        ArrayList buffer = Lists.newArrayList();
        int count = 0;
        if (simulation) {
            log.info((Object)"running in simulation mode ...");
            log.info((Object)String.format("... simulated import of %d records", Iterables.size(rows)));
        } else {
            HTable htable = new HTable(configuration, tableName);
            try {
                int i = 0;
                for (Row row : rows) {
                    this.addOperation(buffer, row);
                    if (++i % this.getBatchSize() != 0) continue;
                    this.flush(tableName, buffer, htable);
                    count += buffer.size();
                    buffer.clear();
                }
            }
            finally {
                if (!buffer.isEmpty()) {
                    this.flush(tableName, buffer, htable);
                    count += buffer.size();
                }
                htable.flushCommits();
                htable.close();
            }
        }
        return count;
    }

    private void flush(String tableName, List<Mutation> buffer, HTable htable) throws IOException, InterruptedException {
        if (!this.checkOp(htable.batch(buffer), tableName)) {
            throw new IOException("unable to flush operation on HBase table: " + tableName);
        }
    }

    private boolean checkOp(Object[] res, String tableName) throws IOException {
        return Iterables.all(Arrays.asList(res), (Predicate)Predicates.notNull());
    }

    protected Iterable<Row> asRows(String rsJson, String xsl) {
        ResultSet resultSet = ResultSet.fromJson((String)rsJson);
        return Iterables.concat((Iterable)Iterables.transform((Iterable)this.resultSetClient.iter(resultSet, String.class), (Function)XsltRowTransformerFactory.newInstance((String)xsl)));
    }

    protected Configuration getConf(ClusterName clusterName) {
        return this.configurationEnumerator.get(clusterName);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

