/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate;

import eu.dnetlib.enabling.is.sn.AbstractSubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRequest;
import eu.dnetlib.enabling.is.sn.TopicExpressionMatchResult;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionDAO;
import eu.dnetlib.enabling.is.sn.resourcestate.SubscriptionRequestFilter;
import eu.dnetlib.rmi.enabling.SubscriptionRequestRejectedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ResourceStateSubscriptionRegistry
extends AbstractSubscriptionRegistry
implements SubscriptionRegistry {
    private ResourceStateSubscriptionDAO subscriptionDao;
    @Autowired
    private SubscriptionRequestFilter subscriptionRequestFilter;

    @Override
    public String registerSubscription(SubscriptionRequest subscription) throws SubscriptionRequestRejectedException {
        TopicExpressionMatchResult prefixMatch = this.matchPrefix(subscription);
        if (prefixMatch == null) {
            return null;
        }
        TopicExpressionMatchResult typeMatch = this.matchType(prefixMatch.getRest());
        if (typeMatch == null) {
            return null;
        }
        TopicExpressionMatchResult idMatch = this.matchId(typeMatch.getRest());
        if (idMatch == null) {
            return null;
        }
        ResourceStateSubscription rss = new ResourceStateSubscription(subscription, prefixMatch.getPrefix(), typeMatch.getPrefix(), idMatch.getPrefix(), idMatch.getRest());
        if (!this.getSubscriptionRequestFilter().accept(rss)) {
            throw new SubscriptionRequestRejectedException(String.format("rejected subscription request, resourceId: '%s', xpath: '%s', from: %s", rss.getResourceId(), rss.getXpath(), rss.getSubscriber()));
        }
        return this.registerSubscription(rss);
    }

    private String registerSubscription(ResourceStateSubscription subscription) {
        Collection<ResourceStateSubscription> similar = this.subscriptionDao.listSubscriptions(subscription.getPrefix(), subscription.getType(), subscription.getResourceId());
        for (ResourceStateSubscription r : similar) {
            if (r == null || !this.getAddress(subscription.getSubscriberAsEpr()).equals(this.getAddress(r.getSubscriberAsEpr())) || subscription.getXpath() != r.getXpath() && !subscription.getXpath().equals(r.getXpath()) || subscription.getResourceId() != r.getResourceId() && !subscription.getResourceId().equals(r.getResourceId())) continue;
            return r.getSubscriptionId();
        }
        this.subscriptionDao.addSubscription(subscription);
        return subscription.getSubscriptionId();
    }

    @Override
    public boolean unsubscribe(String subId) {
        return this.subscriptionDao.removeSubscription(subId);
    }

    private Object getAddress(W3CEndpointReference epr) {
        DOMResult dom = new DOMResult();
        epr.writeTo((Result)dom);
        try {
            return XPathFactory.newInstance().newXPath().evaluate("//*[local-name() = 'Address']", dom.getNode());
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("cannot construct xpath expression", e);
        }
    }

    public TopicExpressionMatchResult matchType(String rest) {
        Pattern p = Pattern.compile("^(\\*|[a-zA-Z_0-9]*)($|/)(.*)$");
        Matcher m = p.matcher(rest);
        if (!m.matches()) {
            return null;
        }
        return new TopicExpressionMatchResult(m.group(1), m.group(3));
    }

    public TopicExpressionMatchResult matchId(String rest) {
        Pattern p = Pattern.compile("^([^/]*)(.*)");
        Matcher m = p.matcher(rest);
        if (!m.matches()) {
            return null;
        }
        return new TopicExpressionMatchResult(m.group(1), m.group(2));
    }

    public Collection<ResourceStateSubscription> listMatchingSubscriptions(String prefix, String type, String resId) {
        HashSet<ResourceStateSubscription> merged = new HashSet<ResourceStateSubscription>();
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, type, resId));
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, type, "*"));
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, "*", "*"));
        return merged;
    }

    @Override
    protected Collection<String> getAcceptedPrefixes() {
        return Arrays.asList("CREATE", "DELETE", "UPDATE");
    }

    public ResourceStateSubscriptionDAO getSubscriptionDao() {
        return this.subscriptionDao;
    }

    @Required
    public void setSubscriptionDao(ResourceStateSubscriptionDAO subscriptionDao) {
        this.subscriptionDao = subscriptionDao;
    }

    public SubscriptionRequestFilter getSubscriptionRequestFilter() {
        return this.subscriptionRequestFilter;
    }

    public void setSubscriptionRequestFilter(SubscriptionRequestFilter subscriptionRequestFilter) {
        this.subscriptionRequestFilter = subscriptionRequestFilter;
    }
}

