/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.xml.database.XMLDatabase;
import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.xml.sax.SAXException;
import org.xmldb.api.base.XMLDBException;

@Controller
public class ValidationController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(ValidationController.class);
    private static final String INDEX_DO = "/inspector/index.do";
    @Resource(name="existDatabase")
    private transient XMLDatabase xmlDatabase;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private transient ResourceIdentifierResolver resIdResolver;

    @RequestMapping(value={"/inspector/index.do/**/validate"})
    String validate(Model model, HttpServletRequest request) throws XMLDBException, XPathExpressionException, SAXException, IOException, ParserConfigurationException, ISRegistryException, ISLookUpException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/validate", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        log.info((Object)("validating: " + path));
        StringOpaqueResource resource = new StringOpaqueResource(this.xmlDatabase.read(fileName, collection));
        log.info((Object)("validating a " + resource.getResourceType()));
        String newId = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true)).validateProfile(resource.getResourceId());
        StringOpaqueResource valid = new StringOpaqueResource(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(newId));
        String vFileName = this.resIdResolver.getFileName(valid.getResourceId());
        String vCollectionName = this.resIdResolver.getCollectionName(valid.getResourceId());
        return "redirect:../../../" + vCollectionName + "/" + vFileName + "/show";
    }

    @RequestMapping(value={"/inspector/index.do/**/invalidate"})
    String invalidate(Model model, HttpServletRequest request) throws XMLDBException, XPathExpressionException, SAXException, IOException, ParserConfigurationException, ISRegistryException, ISLookUpException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/invalidate", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        log.info((Object)("invalidating: " + path));
        StringOpaqueResource resource = new StringOpaqueResource(this.xmlDatabase.read(fileName, collection));
        log.info((Object)("invalidating a " + resource.getResourceType()));
        String newId = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true)).invalidateProfile(resource.getResourceId());
        StringOpaqueResource invalid = new StringOpaqueResource(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(newId));
        String vFileName = this.resIdResolver.getFileName(invalid.getResourceId());
        String vCollectionName = this.resIdResolver.getCollectionName(invalid.getResourceId());
        return "redirect:../../../" + vCollectionName + "/" + vFileName + "/show";
    }
}

