/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import eu.dnetlib.enabling.is.registry.RegistryBlackboardManager;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistryBlackboardManagerImpl
implements RegistryBlackboardManager {
    private static final Log log = LogFactory.getLog(RegistryBlackboardManagerImpl.class);
    private static final String PADDING = "000";
    private static final int MILLIS = 1000;
    private ISLookUpService isLookup;
    private ISRegistryService registryService;
    private JaxbFactory<BlackboardMessage> messageFactory;
    private MessageDater messageDater = new MessageDater();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(String profId, String messageId, String message) {
        try {
            BlackboardMessage bbm = (BlackboardMessage)this.messageFactory.parse(message);
            bbm.setDate(this.messageDater.getCurrentDate());
            if (bbm.getId() == null || !bbm.getId().equals(messageId)) {
                throw new IllegalArgumentException("invalid blackboard message id");
            }
            RegistryBlackboardManagerImpl registryBlackboardManagerImpl = this;
            synchronized (registryBlackboardManagerImpl) {
                StringOpaqueResource serviceProfile = new StringOpaqueResource(this.isLookup.getResourceProfile(profId));
                Document doc = serviceProfile.asDom();
                Node bboard = (Node)XPathFactory.newInstance().newXPath().evaluate("//BLACKBOARD", doc, XPathConstants.NODE);
                Node messageElement = (Node)XPathFactory.newInstance().newXPath().evaluate("//BLACKBOARD/MESSAGE[@id='" + messageId + "']", doc, XPathConstants.NODE);
                if (messageElement != null) {
                    bboard.removeChild(messageElement);
                }
                this.messageFactory.serialize((Object)bbm, (Result)new DOMResult(bboard));
                this.updateLastStamps(doc, LastStamp.REQUEST, messageId);
                this.registryService.updateProfile(profId, serviceProfile.asString(), serviceProfile.getResourceType());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void updateLastStamps(Document doc, LastStamp stamp, String messageId) throws XPathExpressionException {
        Element lastRequest = (Element)XPathFactory.newInstance().newXPath().evaluate("//BLACKBOARD/LAST_" + (Object)((Object)stamp), doc, XPathConstants.NODE);
        lastRequest.setTextContent(messageId);
        lastRequest.setAttribute("date", this.messageDater.getNumericStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(String profId, String messageId) {
        try {
            RegistryBlackboardManagerImpl registryBlackboardManagerImpl = this;
            synchronized (registryBlackboardManagerImpl) {
                StringOpaqueResource serviceProfile = new StringOpaqueResource(this.isLookup.getResourceProfile(profId));
                Document doc = serviceProfile.asDom();
                Node message = (Node)XPathFactory.newInstance().newXPath().evaluate("//BLACKBOARD/MESSAGE[@id='" + messageId + "']", doc, XPathConstants.NODE);
                message.getParentNode().removeChild(message);
                this.registryService.updateProfile(profId, serviceProfile.asString(), serviceProfile.getResourceType());
            }
            log.debug((Object)("Deleted bb message " + messageId + " from profile " + profId));
        }
        catch (Exception e) {
            log.error((Object)("Error deleting bb message " + messageId + " from profile " + profId), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyMessage(String profId, String message) {
        try {
            BlackboardMessage bbm = (BlackboardMessage)this.messageFactory.parse(message);
            bbm.setDate(this.messageDater.getCurrentDate());
            String messageId = bbm.getId();
            RegistryBlackboardManagerImpl registryBlackboardManagerImpl = this;
            synchronized (registryBlackboardManagerImpl) {
                StringOpaqueResource serviceProfile = new StringOpaqueResource(this.isLookup.getResourceProfile(profId));
                Document doc = serviceProfile.asDom();
                Node messageElement = (Node)XPathFactory.newInstance().newXPath().evaluate("//BLACKBOARD/MESSAGE[@id='" + messageId + "']", doc, XPathConstants.NODE);
                if (messageElement == null) {
                    throw new IllegalArgumentException("no such blackboard message " + messageId + ". Unably to reply");
                }
                Node bboard = messageElement.getParentNode();
                bboard.removeChild(messageElement);
                this.messageFactory.serialize((Object)bbm, (Result)new DOMResult(bboard));
                this.updateLastStamps(doc, LastStamp.RESPONSE, messageId);
                this.registryService.updateProfile(profId, serviceProfile.asString(), serviceProfile.getResourceType());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ISRegistryService getRegistryService() {
        return this.registryService;
    }

    @Required
    public void setRegistryService(ISRegistryService registryService) {
        this.registryService = registryService;
    }

    public JaxbFactory<BlackboardMessage> getMessageFactory() {
        return this.messageFactory;
    }

    @Required
    public void setMessageFactory(JaxbFactory<BlackboardMessage> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public MessageDater getMessageDater() {
        return this.messageDater;
    }

    public void setMessageDater(MessageDater messageDater) {
        this.messageDater = messageDater;
    }

    public ISLookUpService getIsLookup() {
        return this.isLookup;
    }

    @Required
    public void setIsLookup(ISLookUpService isLookup) {
        this.isLookup = isLookup;
    }

    public static enum LastStamp {
        REQUEST,
        RESPONSE;

    }

    public static class MessageDater {
        public String getCurrentDate() {
            return DateUtils.now_ISO8601();
        }

        public String getNumericStamp() {
            return Long.toString(System.currentTimeMillis() / 1000L) + "." + System.currentTimeMillis() % 1000L + RegistryBlackboardManagerImpl.PADDING;
        }
    }
}

