/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.AbstractNotificationSender;
import eu.dnetlib.enabling.is.sn.NotificationMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsynchronousNotificationSenderImpl
extends AbstractNotificationSender
implements Runnable {
    private static final Log log = LogFactory.getLog(AsynchronousNotificationSenderImpl.class);
    private BlockingQueue<NotificationJob> jobQueue = new LinkedBlockingQueue<NotificationJob>();

    @Override
    public void send(W3CEndpointReference destination, NotificationMessage message) {
        log.debug((Object)"queuing asynchronous notification");
        try {
            this.jobQueue.put(new NotificationJob(destination, message));
        }
        catch (InterruptedException e) {
            log.warn((Object)"possibly lost notification", (Throwable)e);
        }
    }

    void start() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    NotificationJob job = this.jobQueue.take();
                    try {
                        this.getInvoker().send(job.getDestination(), job.getMessage(), 0);
                        continue block4;
                    }
                    catch (SOAPFaultException t) {
                        log.fatal((Object)("error sending notification to " + job.getDestination().toString()), (Throwable)t);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)"possibly lost notification", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public BlockingQueue<NotificationJob> getJobQueue() {
        return this.jobQueue;
    }

    public void setJobQueue(BlockingQueue<NotificationJob> jobQueue) {
        this.jobQueue = jobQueue;
    }

    class NotificationJob {
        private final transient W3CEndpointReference destination;
        private final transient NotificationMessage message;

        public NotificationJob(W3CEndpointReference destination, NotificationMessage message) {
            this.destination = destination;
            this.message = message;
        }

        public W3CEndpointReference getDestination() {
            return this.destination;
        }

        public NotificationMessage getMessage() {
            return this.message;
        }
    }
}

