package eu.dnetlib.enabling.is.store;

import java.util.List;

public interface ISStore {

	boolean createFileColl(String fileColl) throws ISStoreException;

	boolean deleteFileColl(String fileColl) throws ISStoreException;

	boolean deleteXML(String fileName, String fileColl) throws ISStoreException;

	boolean executeXUpdate(String query) throws ISStoreException;

	List<String> getFileColls() throws ISStoreException;

	List<String> getFileNames(String fileColl) throws ISStoreException;

	String getXML(String fileName, String fileColl) throws ISStoreException;

	String getXMLbyQuery(String query) throws ISStoreException;

	boolean insertXML(String fileName, String fileColl, String file) throws ISStoreException;

	List<String> quickSearchXML(String query) throws ISStoreException;

	boolean updateXML(String fileName, String fileColl, String file) throws ISStoreException;

	String backup() throws ISStoreException;
}
