/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.miscutils.functional.xml.XMLIndenter;
import eu.dnetlib.xml.database.Trigger;
import eu.dnetlib.xml.database.exist.EventType;
import eu.dnetlib.xml.database.exist.ExistTriggerRegistry;
import eu.dnetlib.xml.database.exist.ExistsTriggerEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.Collection;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;

public class DelegatingDiffTrigger
extends SAXTrigger {
    private static final Log log = LogFactory.getLog(DelegatingDiffTrigger.class);
    private String triggerName;
    private Map<String, ExistsTriggerEvent> existsTriggerEventMap = new HashMap<String, ExistsTriggerEvent>();
    private XMLIndenter indenter = new XMLIndenter();

    public void configure(DBBroker dbBroker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        List<?> myTriggerName;
        super.configure(dbBroker, parent, parameters);
        if (parameters == null) {
            return;
        }
        Map<String, List<?>> params = parameters;
        if (parameters.containsKey("triggerName") && (myTriggerName = parameters.get("triggerName")) != null && myTriggerName.size() == 1) {
            this.setTriggerName(myTriggerName.get(0).toString());
        }
        if (this.getTriggerName() == null) {
            log.fatal((Object)"trigger id not configured");
            throw new TriggerException("trigger name not configured");
        }
    }

    protected Trigger getTrigger() {
        Trigger trigger = ExistTriggerRegistry.defaultInstance().getTrigger(this.getTriggerName());
        if (trigger == null) {
            log.fatal((Object)("no trigger " + this.triggerName + " but there is a registered callback for it"));
            return null;
        }
        return trigger;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerId) {
        this.triggerName = triggerId;
    }

    public void beforeCreateDocument(DBBroker dbBroker, Txn txn, XmldbURI xmldbURI) throws TriggerException {
    }

    public void afterCreateDocument(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
        try {
            Trigger trigger = this.getTrigger();
            String collection = document.getCollection().getURI().toString();
            String fileName = document.getFileURI().toString();
            if (trigger != null) {
                trigger.created(fileName, collection, (Document)document);
            }
        }
        catch (Exception e) {
            throw new TriggerException(e);
        }
    }

    public void beforeUpdateDocument(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
        try {
            String collection = document.getCollection().getURI().toString();
            String fileName = document.getFileURI().toString();
            ExistsTriggerEvent event = new ExistsTriggerEvent();
            event.setOldDocument(this.indenter.parseXmlString(XMLIndenter.indent((Document)document)));
            event.setEventType(EventType.UPDATE);
            event.setCollection(collection);
            event.setName(fileName);
            this.existsTriggerEventMap.put(String.valueOf(txn.getId()), event);
        }
        catch (Exception e) {
            throw new TriggerException(e);
        }
    }

    public void afterUpdateDocument(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
        try {
            if (!this.existsTriggerEventMap.containsKey(String.valueOf(txn.getId()))) {
                throw new TriggerException("Error on trigger missing previous operation beforeUpdateTrigger");
            }
            ExistsTriggerEvent existsTriggerEvent = this.existsTriggerEventMap.remove(String.valueOf(txn.getId()));
            existsTriggerEvent.setDocument(this.indenter.parseXmlString(XMLIndenter.indent((Document)document)));
            Trigger trigger = this.getTrigger();
            if (trigger != null) {
                trigger.updated(existsTriggerEvent.getName(), existsTriggerEvent.getCollection(), existsTriggerEvent.getOldDocument(), existsTriggerEvent.getDocument());
            }
        }
        catch (Exception e) {
            throw new TriggerException(e);
        }
    }

    public void beforeUpdateDocumentMetadata(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    public void afterUpdateDocumentMetadata(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    public void beforeCopyDocument(DBBroker dbBroker, Txn txn, DocumentImpl document, XmldbURI xmldbURI) throws TriggerException {
    }

    public void afterCopyDocument(DBBroker dbBroker, Txn txn, DocumentImpl document, XmldbURI xmldbURI) throws TriggerException {
    }

    public void beforeMoveDocument(DBBroker dbBroker, Txn txn, DocumentImpl document, XmldbURI xmldbURI) throws TriggerException {
    }

    public void afterMoveDocument(DBBroker dbBroker, Txn txn, DocumentImpl document, XmldbURI xmldbURI) throws TriggerException {
    }

    public void beforeDeleteDocument(DBBroker dbBroker, Txn txn, DocumentImpl document) throws TriggerException {
        try {
            Trigger trigger = this.getTrigger();
            String collection = document.getCollection().getURI().toString();
            String fileName = document.getFileURI().toString();
            if (trigger != null) {
                trigger.deleted(fileName, collection, this.indenter.parseXmlString(XMLIndenter.indent((Document)document)));
            }
        }
        catch (Exception e) {
            throw new TriggerException(e);
        }
    }

    public void afterDeleteDocument(DBBroker dbBroker, Txn txn, XmldbURI xmldbURI) throws TriggerException {
    }
}

