/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.EPRUtil;
import eu.dnetlib.enabling.is.sn.NotificationInvocationLogger;
import eu.dnetlib.enabling.is.sn.NotificationMessage;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class MemoryNotificationInvocationLogger
implements NotificationInvocationLogger {
    private static final int DEFAULT_SIZE = 100;
    private ConcurrentLinkedQueue<NotificationInvocationLogger.Entry> queue = new ConcurrentLinkedQueue();
    private int size = 100;

    @Override
    public NotificationInvocationLogger.Entry startLogging(W3CEndpointReference dest, NotificationMessage message) {
        NotificationInvocationLogger.Entry entry = this.createLoggingEntry(dest, message);
        this.queue.add(entry);
        this.ensureQueueLength();
        return entry;
    }

    private void ensureQueueLength() {
        if (this.queue.size() > this.size) {
            this.queue.poll();
        }
    }

    protected NotificationInvocationLogger.Entry createLoggingEntry(W3CEndpointReference dest, NotificationMessage message) {
        return new MemoryEntry(dest, message);
    }

    public ConcurrentLinkedQueue<NotificationInvocationLogger.Entry> getQueue() {
        return this.queue;
    }

    public void setQueue(ConcurrentLinkedQueue<NotificationInvocationLogger.Entry> queue) {
        this.queue = queue;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public Collection<NotificationInvocationLogger.Entry> getEntries() {
        return this.getQueue();
    }

    public class MemoryEntry
    implements NotificationInvocationLogger.Entry {
        private NotificationMessage message;
        private NotificationInvocationLogger.Entry.Status status = NotificationInvocationLogger.Entry.Status.Queued;
        private Throwable exception;
        private W3CEndpointReference destinationEpr;
        private Date start;
        private Date finish;

        public MemoryEntry(W3CEndpointReference endpointReference, NotificationMessage message) {
            this.destinationEpr = endpointReference;
            this.message = message;
            this.start = new Date();
        }

        @Override
        public void ongoing() {
            this.status = NotificationInvocationLogger.Entry.Status.Ongoing;
        }

        @Override
        public void failure(Throwable exc) {
            this.status = NotificationInvocationLogger.Entry.Status.Failed;
            this.exception = exc;
            this.commit();
        }

        @Override
        public void success() {
            this.status = NotificationInvocationLogger.Entry.Status.Succeeded;
            this.commit();
        }

        protected void commit() {
            this.finish = new Date();
        }

        @Override
        public NotificationMessage getMessage() {
            return this.message;
        }

        public void setMessage(NotificationMessage message) {
            this.message = message;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public NotificationInvocationLogger.Entry.Status getStatus() {
            return this.status;
        }

        public void setStatus(NotificationInvocationLogger.Entry.Status status) {
            this.status = status;
        }

        public W3CEndpointReference getDestinationEpr() {
            return this.destinationEpr;
        }

        public void setDestinationEpr(W3CEndpointReference destinationEpr) {
            this.destinationEpr = destinationEpr;
        }

        @Override
        public String getDestination() {
            return EPRUtil.getAddress(this.destinationEpr);
        }

        @Override
        public String getErrorMessage() {
            if (this.getException() == null) {
                return "";
            }
            return this.getException().getMessage();
        }

        @Override
        public Date getStart() {
            return this.start;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        @Override
        public Date getFinish() {
            return this.finish;
        }

        public void setFinish(Date finish) {
            this.finish = finish;
        }

        @Override
        public String getDuration() {
            if (this.finish == null || this.start == null) {
                return "-";
            }
            return this.finish.getTime() - this.start.getTime() + " ms";
        }
    }
}

