/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.DnetInformationServiceException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.BulkResourceImporter;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ResourceLoaderHelper;
import eu.dnetlib.enabling.tools.StreamOpaqueResource;
import eu.dnetlib.miscutils.coupling.StaticCondition;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class DnetContentInitializer {
    static final Log log = LogFactory.getLog(DnetContentInitializer.class);
    private static final double MILLIS = 1000.0;
    private static boolean initialized = false;
    private String resources;
    private String schemas;
    private ResourceLoaderHelper resourceLoader;
    private StaticCondition snDisable;
    private UniqueServiceLocator serviceLocator;
    private BulkResourceImporter bulkImporter;
    private int timeToSleep;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void setInitialized(boolean initialized) {
        DnetContentInitializer.initialized = initialized;
    }

    private void registerSchema(URL url) throws IOException, ISRegistryException {
        String resourceType = FilenameUtils.getBaseName((String)url.getPath());
        log.info((Object)("registering schema: " + resourceType));
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)url.openStream(), (Writer)writer);
        ISRegistryService service = null;
        while (service == null) {
            try {
                service = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true);
                service.addResourceType(resourceType, writer.getBuffer().toString());
                log.debug((Object)"The is registry service is ready ");
            }
            catch (Exception e) {
                log.fatal((Object)"The is registry service is not ready ", (Throwable)e);
                try {
                    Thread.sleep(this.timeToSleep);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1);
                }
            }
        }
    }

    private void registerProfile(URL url) throws IOException, ISRegistryException, XPathExpressionException, SAXException, ParserConfigurationException {
        log.debug((Object)("registering profile: " + url));
        this.bulkImporter.importResource((OpaqueResource)new StreamOpaqueResource(url.openStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws DnetInformationServiceException {
        log.info((Object)"Initializing store with some profiles and collections for test and development ...");
        if (!this.getBulkImporter().isEnabled()) {
            log.info((Object)"skipping store initialization because the database already exists");
            return;
        }
        log.info((Object)("loading resources: " + this.getResources()));
        try {
            String type = "schema/profile";
            String name = "none";
            try {
                long start = System.currentTimeMillis();
                type = "schema";
                for (Resource res : this.resourceLoader.getResourcePatternResolver().getResources(this.schemas)) {
                    name = res.getURL().toString();
                    this.registerSchema(res.getURL());
                }
                try {
                    this.snDisable.setCondition(true);
                    type = "profile";
                    for (Resource res : this.resourceLoader.getResourcePatternResolver().getResources(this.resources)) {
                        name = res.getURL().toString();
                        this.registerProfile(res.getURL());
                    }
                }
                finally {
                    this.snDisable.setCondition(false);
                }
                log.info((Object)("bulk registration finished in: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s"));
            }
            catch (ISRegistryException e) {
                log.fatal((Object)("cannot register " + type + ": " + name), (Throwable)e);
                throw new DnetInformationServiceException("registry exception", e);
            }
            catch (IOException e) {
                throw new DnetInformationServiceException("io exception", e);
            }
            catch (XPathExpressionException e) {
                throw new DnetInformationServiceException("xpath exception", e);
            }
            catch (SAXException e) {
                throw new DnetInformationServiceException("sax exception", e);
            }
            catch (ParserConfigurationException e) {
                throw new DnetInformationServiceException("parser exception", e);
            }
        }
        finally {
            log.info((Object)"INITIALIZED");
            DnetContentInitializer.setInitialized(true);
        }
    }

    public String getResources() {
        return this.resources;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    @Required
    public ResourceLoaderHelper getResourceLoader() {
        return this.resourceLoader;
    }

    @Required
    public void setResourceLoader(ResourceLoaderHelper resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public String getSchemas() {
        return this.schemas;
    }

    @Required
    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public StaticCondition getSnDisable() {
        return this.snDisable;
    }

    public void setSnDisable(StaticCondition snDisable) {
        this.snDisable = snDisable;
    }

    public BulkResourceImporter getBulkImporter() {
        return this.bulkImporter;
    }

    @Required
    public void setBulkImporter(BulkResourceImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public int getTimeToSleep() {
        return this.timeToSleep;
    }

    @Required
    public void setTimeToSleep(int timeToSleep) {
        this.timeToSleep = timeToSleep;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

