/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.inspector.ResourceLinkTool;
import eu.dnetlib.xml.database.XMLDatabase;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.xmldb.api.base.XMLDBException;

@Controller
public class ResourceTreeController
extends AbstractInspectorController {
    private static final String INDEX_DO = "/inspector/index.do";
    private static final Log log = LogFactory.getLog(ResourceTreeController.class);
    @Resource(name="existDatabase")
    private transient XMLDatabase xmlDatabase;
    @Resource(name="resourcelinkTool")
    private ResourceLinkTool linkTool;

    public ResourceTreeController() {
        log.info((Object)"ResourceTreeController created");
    }

    @RequestMapping(value={"/inspector/index.do"})
    String indexDo() {
        return "redirect:index.do/db/list";
    }

    @RequestMapping(value={"/inspector/index.do/**/list"})
    String list(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/list", "");
        log.debug((Object)("xml db: " + this.xmlDatabase));
        List<String> children = this.xmlDatabase.listChildCollections(path);
        List<String> files = this.xmlDatabase.list(path);
        Collections.sort(children);
        Collections.sort(files);
        Collection richChildren = children.stream().map(it -> new CollectionModel(path, ".", (String)it)).collect(Collectors.toList());
        model.addAttribute("path", (Object)path);
        model.addAttribute("pathComponents", this.extractPathComponents(path, ""));
        model.addAttribute("collections", (Object)richChildren);
        model.addAttribute("files", files);
        model.addAttribute("title", (Object)"Title");
        return "inspector/index";
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, String>> extractPathComponents(String path, String base) {
        void var7_9;
        String[] rawPathComponents = path.split("/");
        ArrayList<Map<String, String>> pathComponents = new ArrayList<Map<String, String>>();
        String[] stringArray = rawPathComponents;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String rawPathComponent = stringArray[var7_9];
            HashMap<String, String> pathElement = new HashMap<String, String>();
            pathElement.put("name", rawPathComponent);
            pathComponents.add(pathElement);
            ++var7_9;
        }
        Collections.reverse(pathComponents);
        StringBuffer current = new StringBuffer(base);
        for (Map map : pathComponents) {
            map.put("url", current.toString());
            current.append("../");
        }
        Collections.reverse(pathComponents);
        return pathComponents;
    }

    @RequestMapping(value={"/inspector/index.do/**/show"})
    String show(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/show", "");
        log.info((Object)("index: " + path));
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        String file = this.xmlDatabase.read(fileName, collection);
        if (file == null) {
            file = "no such file, click on edit to create";
        }
        file = StringEscapeUtils.escapeHtml4((String)file);
        model.addAttribute("file", (Object)this.linkTool.linkfyToHtml(file));
        model.addAttribute("pathComponents", this.extractPathComponents(collection, "../"));
        return "inspector/show";
    }

    @RequestMapping(value={"/inspector/index.do/**/raw"})
    void raw(HttpServletRequest request, HttpServletResponse response) throws XMLDBException, IOException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/raw", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        String file = this.xmlDatabase.read(fileName, collection);
        if (file == null) {
            file = "no such file to show";
        }
        response.setContentType("text/xml");
        ServletOutputStream out = response.getOutputStream();
        IOUtils.copy((Reader)new StringReader(file), (OutputStream)out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/inspector/index.do/**/edit"})
    String edit(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/edit", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        String file = this.xmlDatabase.read(fileName, collection);
        if (file == null) {
            model.addAttribute("creating", (Object)"true");
        }
        model.addAttribute("file", (Object)StringEscapeUtils.escapeHtml4((String)file));
        model.addAttribute("pathComponents", this.extractPathComponents(collection, "../"));
        return "inspector/edit";
    }

    @RequestMapping(value={"/inspector/index.do/**/save"})
    String save(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/save", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        log.info((Object)("saving: " + path));
        String source = request.getParameter("source");
        if ("true".equals(request.getParameter("creating"))) {
            this.xmlDatabase.create(fileName, collection, source);
        } else {
            this.xmlDatabase.update(fileName, collection, source);
        }
        return "redirect:show";
    }

    @RequestMapping(value={"/inspector/index.do/**/delete"})
    String delete(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/delete", "");
        File fileHelper = new File(path);
        String collection = fileHelper.getParent();
        String fileName = fileHelper.getName();
        log.info((Object)("deleting: " + path));
        this.xmlDatabase.remove(fileName, collection);
        return "redirect:../list";
    }

    @RequestMapping(value={"/inspector/index.do/**/deleteCollection"})
    String deleteCollection(Model model, HttpServletRequest request) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/deleteCollection", "");
        this.xmlDatabase.removeCollection(path);
        return "redirect:../list";
    }

    @RequestMapping(value={"/inspector/index.do/**/createsubcoll"})
    String createSubCollection(Model model, HttpServletRequest request) throws XMLDBException {
        return "inspector/createsubcoll";
    }

    @RequestMapping(value={"/inspector/index.do/**/savesubcoll"})
    String saveSubCollection(Model model, HttpServletRequest request, @RequestParam(value="collectionPath") String collectionPath) throws XMLDBException {
        String path = request.getPathInfo().replace(INDEX_DO, "").replace("/savesubcoll", "");
        String fullPath = path + "/" + collectionPath;
        log.info((Object)("Creating subcollection: " + fullPath));
        if (!this.xmlDatabase.collectionExists(fullPath)) {
            this.xmlDatabase.createCollection(fullPath);
        } else {
            log.info((Object)("Subcollection: " + fullPath + " already exists"));
        }
        return "redirect:../list";
    }

    @RequestMapping(value={"/inspector/index.do/**/create"})
    String create(Model model, HttpServletRequest request) throws XMLDBException {
        return "inspector/create";
    }

    @RequestMapping(value={"/inspector/gadget.do"})
    void gadget(Model model) {
        log.info((Object)"GADGED CALLED");
        model.addAttribute("items", (Object)new String[]{"one", "two", "three"});
    }

    public class CollectionModel {
        private String path;
        private String rel;
        private String name;

        public CollectionModel(String path, String rel, String name) {
            this.path = path;
            this.rel = rel;
            this.name = name;
        }

        public Collection<CollectionModel> getCollectionPath() {
            ArrayList<CollectionModel> res = new ArrayList<CollectionModel>();
            res.add(this);
            try {
                List<String> children = ResourceTreeController.this.xmlDatabase.listChildCollections(this.path + '/' + this.name);
                if (children.size() == 1) {
                    res.addAll(new CollectionModel(this.path + '/' + this.name, this.rel + '/' + this.name, children.get(0)).getCollectionPath());
                }
                return res;
            }
            catch (XMLDBException e) {
                return res;
            }
        }

        public String getUrl() {
            return this.rel + '/' + this.getName();
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

