/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.sn.ISSNServiceCore;
import eu.dnetlib.xml.database.XMLDatabase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.helpers.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class BackupController
extends AbstractInspectorController {
    private static final int BUFFER_SIZE = 4096;
    private static final Log log = LogFactory.getLog(BackupController.class);
    @Resource(name="existDatabase")
    private transient XMLDatabase xmlDatabase;
    @Resource(name="isSNServiceCore")
    private transient ISSNServiceCore issnServiceCore;

    @RequestMapping(value={"/inspector/backups.do"})
    public void backup(Model model) {
    }

    @RequestMapping(value={"/inspector/backupProfiles.do"})
    public void backupProfiles(Model model, @RequestParam(value="exec", required=false) String exec, @RequestParam(value="delete", required=false) String delete) {
        if (exec != null && exec.equals("1")) {
            this.execProfileBackup(model);
        }
        if (delete != null) {
            this.deleteBackup(model, this.xmlDatabase.getBackupDir(), delete);
        }
        this.listBackups(model, this.xmlDatabase.getBackupDir());
    }

    @RequestMapping(value={"/inspector/backupSubscriptions.do"})
    public void backupSubscriptions(Model model, @RequestParam(value="exec", required=false) String exec, @RequestParam(value="delete", required=false) String delete) {
        if (exec != null && exec.equals("1")) {
            this.execSubscriptionsBackup(model);
        }
        if (delete != null) {
            this.deleteBackup(model, this.issnServiceCore.getBackupDir(), delete);
        }
        this.listBackups(model, this.issnServiceCore.getBackupDir());
    }

    private void execProfileBackup(Model model) {
        try {
            this.xmlDatabase.backup();
            log.info((Object)"Backup done");
        }
        catch (Exception e) {
            model.addAttribute("message", (Object)"Backup failed: please retry later");
            log.fatal((Object)"Backup failed", (Throwable)e);
        }
    }

    private void execSubscriptionsBackup(Model model) {
        try {
            this.issnServiceCore.backup();
            log.info((Object)"Backup done");
        }
        catch (Exception e) {
            model.addAttribute("message", (Object)"Backup failed: please retry later");
            log.fatal((Object)"Backup failed", (Throwable)e);
        }
    }

    private void deleteBackup(Model model, String backupDir, String backup) {
        try {
            String logFile = backup.replaceFirst("data-", "report-").replace(".zip", ".log");
            new File(backupDir + "/" + backup).delete();
            new File(backupDir + "/" + logFile).delete();
            log.info((Object)"Backup deleted");
        }
        catch (Exception e) {
            model.addAttribute("message", (Object)("failed: " + e.getMessage()));
            log.info((Object)("Backup deletion failed: " + e.getMessage()));
        }
    }

    private void listBackups(Model model, String backupDir) {
        FilenameFilter filter;
        File[] list;
        model.addAttribute("size", (Object)0);
        File dir = new File(backupDir);
        if (dir.exists() && dir.isDirectory() && (list = dir.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("data-") && name.endsWith(".zip");
            }
        })) != null) {
            Arrays.sort(list, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
            model.addAttribute("size", (Object)list.length);
            model.addAttribute("backups", (Object)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/inspector/backupLog.do"})
    void backupLog(Model model, @RequestParam(value="backup") String backup, @RequestParam(value="type") String type) throws IOException {
        String logFile = backup.replaceFirst("data-", "report-").replace(".zip", ".log");
        StringWriter blog = new StringWriter();
        try (FileReader freader = new FileReader(this.getBackupDir(type) + "/" + logFile);){
            IOUtils.copy((Reader)freader, (Writer)blog, (int)4096);
        }
        model.addAttribute("log", (Object)blog);
        model.addAttribute("backup", (Object)backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/inspector/backupDownload.do"})
    void downloadBackup(HttpServletResponse response, @RequestParam(value="backup", required=true) String backup, @RequestParam(value="type", required=true) String type, OutputStream out) throws IOException {
        response.setContentType("application/zip");
        String endUserFilename = backup.replaceFirst("data", "dlib-backup-" + type);
        response.addHeader("Content-disposition", "attachment; filename=" + endUserFilename);
        try (FileInputStream backupStream = new FileInputStream(this.getBackupDir(type) + "/" + backup);){
            IOUtils.copy((InputStream)backupStream, (OutputStream)out);
        }
        out.flush();
        out.close();
    }

    private String getBackupDir(String type) {
        switch (BackupType.valueOf(type)) {
            case profile: {
                return this.xmlDatabase.getBackupDir();
            }
            case subscription: {
                return this.issnServiceCore.getBackupDir();
            }
        }
        throw new IllegalArgumentException("wrong backup type parameter: " + type);
    }

    private static enum BackupType {
        profile,
        subscription;

    }
}

