/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.enabling.is.sn.SubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRequest;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionRegistry;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.enabling.ISSNException;
import eu.dnetlib.rmi.enabling.SubscriptionRequestRejectedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ISSNServiceCore {
    private static final Log log = LogFactory.getLog(ISSNServiceCore.class);
    private Collection<ResourceStateSubscriptionRegistry> registries;
    private String backupDir;

    public String subscribe(W3CEndpointReference consumerReference, String topicExpression, int ttl) throws SubscriptionRequestRejectedException {
        log.debug((Object)"subscribing");
        SubscriptionRequest srq = new SubscriptionRequest("sn" + UUID.randomUUID().toString(), consumerReference, topicExpression, ttl);
        for (SubscriptionRegistry subscriptionRegistry : this.registries) {
            String subId = subscriptionRegistry.registerSubscription(srq);
            if (subId == null) continue;
            return subId;
        }
        return null;
    }

    public boolean unsubscribe(String subscrId) {
        for (SubscriptionRegistry subscriptionRegistry : this.registries) {
            boolean succeeded = subscriptionRegistry.unsubscribe(subscrId);
            if (!succeeded) continue;
            return true;
        }
        return false;
    }

    public String backup() throws ISSNException {
        log.info((Object)"Starting backup...");
        try {
            this.verifyBackupDir();
            String seq = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.backupDir + "/data-" + seq + ".zip"));
            FileWriter logFile = new FileWriter(this.backupDir + "/report-" + seq + ".log");
            logFile.write("Backup started at: " + DateUtils.now_ISO8601() + "\n\n");
            this.backup(zip, logFile);
            logFile.write("\nBackup finished at: " + DateUtils.now_ISO8601() + "\n");
            logFile.flush();
            logFile.close();
            zip.flush();
            zip.close();
            log.info((Object)"Backup finished");
            return this.backupDir;
        }
        catch (Exception e) {
            log.error((Object)"Backup failed", (Throwable)e);
            throw new ISSNException("cannot backup", (Throwable)e);
        }
    }

    private void backup(ZipOutputStream zip, FileWriter logFile) throws IOException {
        for (ResourceStateSubscriptionRegistry registry : this.registries) {
            for (ResourceStateSubscription sub : registry.getSubscriptionDao().listSubscriptions()) {
                logFile.write("SUBSCRIPTION: " + sub.getSubscriptionId() + "\n");
                log.info((Object)("Backup of subscription: " + sub.getSubscriptionId()));
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("prefix", sub.getPrefix());
                attrs.put("type", sub.getType());
                attrs.put("resourceId", sub.getResourceId());
                attrs.put("xpath", sub.getXpath());
                attrs.put("id", sub.getSubscriptionId());
                attrs.put("subscriber", sub.getSubscriber().toString());
                zip.putNextEntry(new ZipEntry(sub.getSubscriptionId()));
                zip.write(this.encodeJSon(attrs).getBytes());
                zip.closeEntry();
            }
        }
    }

    private String encodeJSon(Map<String, String> map) {
        return new Gson().toJson(map, new TypeToken<Map<String, String>>(){}.getType());
    }

    private void verifyBackupDir() {
        File d = new File(this.backupDir);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    public Collection<ResourceStateSubscriptionRegistry> getRegistries() {
        return this.registries;
    }

    public void setRegistries(Collection<ResourceStateSubscriptionRegistry> registries) {
        this.registries = registries;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    @Required
    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }
}

