/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.xml.database.exist.ExistDatabase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemporaryExistDatabase
extends ExistDatabase {
    private static final Log log = LogFactory.getLog(TemporaryExistDatabase.class);
    private transient File tempDirectory;
    private String configTemplate = "default-exist-conf.xml";

    @Override
    public void start() {
        log.warn((Object)"STARTING TEMPORARY EXIST DATABASE");
        this.createTemporaryDatabase();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            FileUtils.deleteDirectory((File)this.tempDirectory);
        }
        catch (IOException e) {
            log.fatal((Object)"cannot delete temporary exist directory", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTemporaryDatabase() {
        log.debug((Object)"creating temp database");
        try {
            File tmpName = File.createTempFile("exist", "");
            tmpName.delete();
            this.tempDirectory = new File(tmpName.getAbsolutePath());
            new File(this.tempDirectory, "data").mkdirs();
            InputStream defaultConf = this.getClass().getResourceAsStream(this.getConfigTemplate());
            if (defaultConf == null) {
                throw new IOException("cannot find " + this.getConfigTemplate());
            }
            File existConfigFile = new File(this.tempDirectory, "conf.xml");
            try (FileOutputStream confOutput = new FileOutputStream(existConfigFile);){
                IOUtils.copy((InputStream)defaultConf, (OutputStream)confOutput);
            }
            this.setConfigFile(existConfigFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.fatal((Object)"creating database dir", (Throwable)e);
            throw new IllegalStateException(e);
        }
        log.debug((Object)"created temp database");
    }

    protected String getConfigTemplate() {
        return this.configTemplate;
    }

    protected void setConfigTemplate(String configTemplate) {
        this.configTemplate = configTemplate;
    }
}

