/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.inspector.ResourceLinkTool;
import eu.dnetlib.xml.database.XMLDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.xmldb.api.base.XMLDBException;

@Controller
public class QueryController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(QueryController.class);
    @Resource(name="existDatabase")
    private transient XMLDatabase xmlDatabase;
    @Resource(name="resourcelinkTool")
    private ResourceLinkTool linkTool;

    @RequestMapping(value={"/inspector/query.do"})
    void query(Model model, @RequestParam(value="query", required=false) String query) {
        if (query != null) {
            log.info((Object)("running query: " + query));
            try {
                Iterator<String> res = this.xmlDatabase.xquery(query);
                ArrayList results = new ArrayList();
                res.forEachRemaining(it -> results.add(this.linkTool.linkfyToHtml(StringEscapeUtils.escapeHtml4((String)it))));
                model.addAttribute("size", (Object)results.size());
                model.addAttribute("results", results);
            }
            catch (XMLDBException e) {
                model.addAttribute("message", (Object)("failed: " + e.getMessage()));
            }
        }
        model.addAttribute("query", (Object)query);
    }
}

