/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import eu.dnetlib.enabling.is.registry.PendingResourceManager;
import eu.dnetlib.enabling.is.registry.ResourceKindResolver;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.is.registry.validation.ProfileValidationStrategy;
import eu.dnetlib.enabling.is.registry.validation.RegistrationPhase;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class CompatPendingResourceManagerImpl
implements PendingResourceManager,
ResourceKindResolver {
    private ISRegistryService isRegistry;
    private ResourceKindResolver resourceKindResolver;
    @Autowired
    private ProfileValidationStrategy profileValidationStrategy;

    @Override
    public void setPending(OpaqueResource resource, boolean local) {
        try {
            resource.setResourceKind(this.getPendingKindForType(resource.getResourceType()));
            if (!local) {
                this.isRegistry.deleteProfile(resource.getResourceId());
                String newId = this.isRegistry.registerProfile(resource.asString());
                resource.setResourceId(newId);
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setPending(OpaqueResource resource) {
        this.setPending(resource, false);
    }

    @Override
    public void setValid(OpaqueResource resource) {
        try {
            if (resource.getResourceKind() != null && resource.getResourceKind().equals(this.getNormalKindForType(resource.getResourceType()))) {
                throw new IllegalArgumentException("trying to validate an already valid resource");
            }
            this.profileValidationStrategy.accept(resource, RegistrationPhase.Validate);
            resource.setResourceKind(this.getNormalKindForType(resource.getResourceType()));
            this.isRegistry.deleteProfile(resource.getResourceId());
            String newId = this.isRegistry.registerProfile(resource.asString());
            resource.setResourceId(newId);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getNormalKindForType(String resourceType) throws XPathExpressionException {
        return this.resourceKindResolver.getNormalKindForType(resourceType);
    }

    @Override
    public String getPendingKindForType(String resourceType) throws XPathExpressionException {
        return this.resourceKindResolver.getPendingKindForType(resourceType);
    }

    public ResourceKindResolver getResourceKindResolver() {
        return this.resourceKindResolver;
    }

    @Required
    public void setResourceKindResolver(ResourceKindResolver resourceKindResolver) {
        this.resourceKindResolver = resourceKindResolver;
    }

    public ProfileValidationStrategy getProfileValidationStrategy() {
        return this.profileValidationStrategy;
    }

    public void setProfileValidationStrategy(ProfileValidationStrategy profileValidationStrategy) {
        this.profileValidationStrategy = profileValidationStrategy;
    }

    public ISRegistryService getIsRegistry() {
        return this.isRegistry;
    }

    @Required
    public void setIsRegistry(ISRegistryService isRegistry) {
        this.isRegistry = isRegistry;
    }
}

