package eu.dnetlib.enabling.is.sn;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Provides common functionality for subscription registries.
 * 
 * @author marko
 * 
 */
public abstract class AbstractSubscriptionRegistry {

	/**
	 * prefix position in regular expression.
	 */
	private static final int PREFIX_POSITION = 1;
	
	/**
	 * rest of string position in regular expression.
	 */
	private static final int REST_POSITION = 3;
	
	/**
	 * Return true if the subscription prefix is acceptable.
	 * 
	 * Topic expressions are made of slash-delimited components. The "prefix" here is the first slash (/) delimited
	 * string of the topic expression.
	 * 
	 * TODO: stupid implementation.
	 * 
	 * @param subscription
	 *            subscription request
	 * @return true if accepted
	 */
	protected TopicExpressionMatchResult matchPrefix(final SubscriptionRequest subscription) {

		
		for (String prefix : getAcceptedPrefixes()) {
			final Pattern p = Pattern.compile("^(" + prefix + ")($|/)(.*)$");
			final Matcher m = p.matcher(subscription.getTopicExpression());
			if (m.matches()) {
				return new TopicExpressionMatchResult(m.group(PREFIX_POSITION), m.group(REST_POSITION));
			}
		}
		return null;
	}

	/**
	 * A collection of accepted prefixes.
	 * 
	 * @return prefix list
	 */
	protected abstract Collection<String> getAcceptedPrefixes();
}
