package eu.dnetlib.enabling.is.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import eu.dnetlib.xml.database.XMLDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmldb.api.base.XMLDBException;

/**
 * ISStore service implementation.
 * 
 * @author Sandro & Michele
 * 
 */

public class ISStoreImpl  implements ISStore { // NOPMD by marko on 11/24/08

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(ISStoreImpl.class); // NOPMD by marko on 11/24/08 4:46 PM

	/**
	 * xml database used by the ISStore.
	 */
	private XMLDatabase xmlDatabase;


	@Override
	public boolean createFileColl(final String fileColl) throws ISStoreException {
		try {
			xmlDatabase.createCollection(fileColl);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
		return true;
	}



	@Override
	public boolean deleteFileColl(final String fileColl) throws ISStoreException {
		try {
			xmlDatabase.removeCollection(fileColl);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
		return true;
	}


	@Override
	public boolean deleteXML(final String fileName, final String fileColl) throws ISStoreException {
		try {
			return xmlDatabase.remove(fileName, fileColl);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
	}


	@Override
	public boolean executeXUpdate(final String query) throws ISStoreException {
		try {
			xmlDatabase.xupdate(query);
		} catch (XMLDBException e){
			throw new ISStoreException("Error while executing xupdate "+query, e);
		}
		return true;
	}


	@Override
	public List<String> getFileColls() throws ISStoreException {
		try {
			return xmlDatabase.listChildCollections(xmlDatabase.getRootCollection());
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
	}


	@Override
	public List<String> getFileNames(final String fileColl) throws ISStoreException {
		try {
			return xmlDatabase.list(fileColl);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
	}

	@Override
	public String getXML(final String fileName, final String fileColl) throws ISStoreException {
		try {
			return xmlDatabase.read(fileName, fileColl);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
	}

	@Override
	public String getXMLbyQuery(final String query) throws ISStoreException {
		log.debug(query);

		try {
			final Iterator<String> xquery = xmlDatabase.xquery(query);
			if (xquery!=null && xquery.hasNext()){
				return xquery.next();
			}
			return null;
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
	}


	@Override
	public boolean insertXML(final String fileName, final String fileColl, final String file) throws ISStoreException {
		try {
			xmlDatabase.create(fileName, fileColl, file);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
		return true;
	}


	@Override
	public List<String> quickSearchXML(final String query) throws ISStoreException {
		log.debug(query);
		try {
			final Iterator<String> res = xmlDatabase.xquery(query);
			if (res == null) return new ArrayList<>();
			final ArrayList<String> ans = new ArrayList<>();
			res.forEachRemaining(ans::add);
			return ans;
		} catch (XMLDBException e) {
			log.fatal("searching", e);
			throw new ISStoreException(e);
		}
	}

	@Override
	public boolean updateXML(final String fileName, final String fileColl, final String file) throws ISStoreException {
		try {
			xmlDatabase.update(fileName, fileColl, file);
		} catch (XMLDBException e) {
			throw new ISStoreException(e);
		}
		return true;
	}

	@Override
	public String backup() throws ISStoreException {
		try {
			return xmlDatabase.backup();
		} catch (Exception e) {
			throw new ISStoreException(e);
		}
	}

	public XMLDatabase getXmlDatabase() {
		return xmlDatabase;
	}

	public void setXmlDatabase(final XMLDatabase xmlDatabase) {
		this.xmlDatabase = xmlDatabase;
	}

}
