/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.lookup;

import eu.dnetlib.enabling.is.store.ISStore;
import eu.dnetlib.enabling.is.store.ISStoreException;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.CompatResourceIdentifierResolverImpl;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import eu.dnetlib.enabling.tools.XQueryUtils;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

@WebService(targetNamespace="http://services.dnetlib.eu/")
public class ISLookUpServiceImpl
extends AbstractBaseService
implements ISLookUpService {
    private static final String COLLECTION_ERROR = "cannot get collection";
    private static final String DB_BASE_DIR = "/db/DRIVER";
    private static final String PROFILE_NOT_FOUND = "Profile not found";
    private ISStore isStore;
    public static final Log log = LogFactory.getLog(ISLookUpServiceImpl.class);
    private ResourceIdentifierResolver resIdManager = new CompatResourceIdentifierResolverImpl();
    private XQueryUtils xqueryUtils;

    public String retrieveCollection(String profId) throws ISLookUpException {
        try {
            String profile = this.getResourceProfile(profId);
            List<String> list = this.quickSearchProfile("for $x in collection('/db/DRIVER/CollectionDSResources') where $x//FATHER/@id = '" + profId + "' return $x//RESOURCE_IDENTIFIER/@value/string()");
            if (!list.isEmpty()) {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(profile));
                Element childrenNode = (Element)doc.selectSingleNode("//CHILDREN");
                for (String idC : list) {
                    childrenNode.addElement("CHILD").addAttribute("id", idC);
                }
                profile = doc.asXML();
            }
            return profile;
        }
        catch (Exception e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public String getResourceProfile(String profId) throws ISLookUpException {
        if (profId == null || profId.isEmpty()) {
            throw new ISLookUpException("Invalid null profile ID: " + profId);
        }
        try {
            String res = this.isStore.getXML(this.getFileNameForId(profId), this.xqueryUtils.getRootCollection() + this.getFileCollForId(profId));
            if (res == null) {
                throw new ISLookUpDocumentNotFoundException("document " + profId + " not found");
            }
            return res;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)((Object)e));
        }
    }

    String getFileNameForId(String profId) {
        return this.resIdManager.getFileName(profId);
    }

    String getFileCollForId(String profId) {
        return this.resIdManager.getCollectionName(profId);
    }

    public String getResourceProfileByQuery(String xquery) throws ISLookUpException {
        try {
            String resource = this.isStore.getXMLbyQuery(xquery);
            if (resource == null || resource.isEmpty()) {
                throw new ISLookUpDocumentNotFoundException(PROFILE_NOT_FOUND);
            }
            return resource;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)((Object)e));
        }
    }

    public String getResourceQoSParams(String profId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/ServiceResources') where $x//RESOURCE_IDENTIFIER/@value = '" + profId + "' return $x//QOS";
        return this.getResourceProfileByQuery(query);
    }

    public String getResourceTypeSchema(String resourceType) throws ISLookUpException {
        if (resourceType == null || resourceType.isEmpty()) {
            throw new ISLookUpException("Invalid resourceType");
        }
        try {
            return this.isStore.getXML(resourceType, this.xqueryUtils.getRootCollection() + "DRIVERResourceTypes");
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)((Object)e));
        }
    }

    public List<String> listResourceTypes() throws ISLookUpException {
        try {
            return this.isStore.getFileNames("/db/DRIVER/DRIVERResourceTypes");
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)((Object)e));
        }
    }

    public List<String> quickSearchProfile(String xquery) throws ISLookUpException {
        try {
            return this.isStore.quickSearchXML(xquery);
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)((Object)e));
        }
    }

    public ResourceIdentifierResolver getResIdManager() {
        return this.resIdManager;
    }

    public void setResIdManager(ResourceIdentifierResolver resIdManager) {
        this.resIdManager = resIdManager;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    public XQueryUtils getXqueryUtils() {
        return this.xqueryUtils;
    }

    public ISStore getIsStore() {
        return this.isStore;
    }

    @Required
    public void setIsStore(ISStore isStore) {
        this.isStore = isStore;
    }
}

