/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.ISSNServiceCore;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.enabling.ISSNException;
import eu.dnetlib.rmi.enabling.ISSNService;
import eu.dnetlib.rmi.enabling.SubscriptionRequestRejectedException;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISSNServiceImpl
extends AbstractBaseService
implements ISSNService {
    private static final Log log = LogFactory.getLog(ISSNServiceImpl.class);
    private static final int MILLIS_IN_SECOND = 1000;
    private ISSNServiceCore core;
    @Resource(name="jaxwsEndpointReferenceBuilder")
    private EndpointReferenceBuilder<Endpoint> eprBuilder;

    public boolean actionCreatePerformed(String resourceType, String profileId, String profile) throws ISSNException {
        log.fatal((Object)"actionCreatePerformed(String, String, String) not implemented");
        return false;
    }

    public boolean actionDeletePerformed(String resourceType, String profileId) throws ISSNException {
        log.fatal((Object)"actionDeletePerformed(String, String) not implemented");
        return false;
    }

    public boolean actionUpdatePerformed(String resourceType, String profileId, String profileBefore, String profileAfter) throws ISSNException {
        log.fatal((Object)"actionUpdatePerformed(String, String, String, String) not implemented");
        return false;
    }

    public String getCurrentMessage(String topic) throws ISSNException {
        log.fatal((Object)"getCurrentMessage(String) not implemented");
        return null;
    }

    public List<String> listSubscriptions() {
        log.fatal((Object)"listSubscriptions() not implemented");
        return null;
    }

    public boolean pauseSubscription(String subscrId) throws ISSNException {
        log.fatal((Object)"pauseSubscription(String) not implemented");
        return false;
    }

    public boolean renew(String subscrId, int terminationTime) throws ISSNException {
        log.fatal((Object)"renew(String, int) not implemented");
        return false;
    }

    public boolean resumeSubscription(String subscrId) throws ISSNException {
        log.fatal((Object)"resumeSubscription(String) not implemented");
        return false;
    }

    public String subscribe(W3CEndpointReference consumerReference, String topicExpression, int termTime) throws ISSNException, SubscriptionRequestRejectedException {
        log.debug((Object)("subscribe request from: " + consumerReference.toString() + " topic: " + topicExpression));
        int ttl = termTime == 0 ? 0 : (int)((long)termTime - Calendar.getInstance().getTimeInMillis() / 1000L);
        String res = this.core.subscribe(consumerReference, topicExpression, ttl);
        if (res == null) {
            throw new ISSNException("couldn't find a subscription registry for the given topic: " + topicExpression);
        }
        log.debug((Object)("subscribe success, subscriptionId: " + res));
        return res;
    }

    public boolean unsubscribe(String subscrId) throws ISSNException {
        log.debug((Object)("unsubscribe request for: " + subscrId));
        return this.core.unsubscribe(subscrId);
    }

    public ISSNServiceCore getCore() {
        return this.core;
    }

    public void setCore(ISSNServiceCore core) {
        this.core = core;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }
}

