/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import eu.dnetlib.enabling.is.store.ISStore;
import eu.dnetlib.enabling.is.store.ISStoreException;
import eu.dnetlib.xml.database.XMLDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xmldb.api.base.XMLDBException;

public class ISStoreImpl
implements ISStore {
    private static final Log log = LogFactory.getLog(ISStoreImpl.class);
    private XMLDatabase xmlDatabase;

    @Override
    public boolean createFileColl(String fileColl) throws ISStoreException {
        try {
            this.xmlDatabase.createCollection(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
        return true;
    }

    @Override
    public boolean deleteFileColl(String fileColl) throws ISStoreException {
        try {
            this.xmlDatabase.removeCollection(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
        return true;
    }

    @Override
    public boolean deleteXML(String fileName, String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.remove(fileName, fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
    }

    @Override
    public boolean executeXUpdate(String query) throws ISStoreException {
        try {
            this.xmlDatabase.xupdate(query);
        }
        catch (XMLDBException e) {
            throw new ISStoreException("Error while executing xupdate " + query, e);
        }
        return true;
    }

    @Override
    public List<String> getFileColls() throws ISStoreException {
        try {
            return this.xmlDatabase.listChildCollections(this.xmlDatabase.getRootCollection());
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
    }

    @Override
    public List<String> getFileNames(String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.list(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
    }

    @Override
    public String getXML(String fileName, String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.read(fileName, fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
    }

    @Override
    public String getXMLbyQuery(String query) throws ISStoreException {
        log.debug((Object)query);
        try {
            Iterator<String> xquery = this.xmlDatabase.xquery(query);
            if (xquery != null && xquery.hasNext()) {
                return xquery.next();
            }
            return null;
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
    }

    @Override
    public boolean insertXML(String fileName, String fileColl, String file) throws ISStoreException {
        try {
            this.xmlDatabase.create(fileName, fileColl, file);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
        return true;
    }

    @Override
    public List<String> quickSearchXML(String query) throws ISStoreException {
        log.debug((Object)query);
        try {
            Iterator<String> res = this.xmlDatabase.xquery(query);
            if (res == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> ans = new ArrayList<String>();
            res.forEachRemaining(ans::add);
            return ans;
        }
        catch (XMLDBException e) {
            log.fatal((Object)"searching", (Throwable)e);
            throw new ISStoreException(e);
        }
    }

    @Override
    public boolean updateXML(String fileName, String fileColl, String file) throws ISStoreException {
        try {
            this.xmlDatabase.update(fileName, fileColl, file);
        }
        catch (XMLDBException e) {
            throw new ISStoreException(e);
        }
        return true;
    }

    @Override
    public String backup() throws ISStoreException {
        try {
            return this.xmlDatabase.backup();
        }
        catch (Exception e) {
            throw new ISStoreException(e);
        }
    }

    public XMLDatabase getXmlDatabase() {
        return this.xmlDatabase;
    }

    public void setXmlDatabase(XMLDatabase xmlDatabase) {
        this.xmlDatabase = xmlDatabase;
    }
}

