/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.xml.database.exist;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.xml.database.Trigger;
import eu.dnetlib.xml.database.XMLDatabase;
import eu.dnetlib.xml.database.exist.DelegatingDiffTrigger;
import eu.dnetlib.xml.database.exist.ExistTriggerRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exist.collections.CollectionConfiguration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xmldb.DatabaseImpl;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.XmldbURI;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.Lifecycle;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XPathQueryService;

public class ExistDatabase
implements XMLDatabase,
Lifecycle {
    private static final Log log = LogFactory.getLog(ExistDatabase.class);
    public static final String COLLECTION_XCONF = "collection.xconf";
    private static final String XMLRESOURCE = "XMLResource";
    private Map<String, Trigger> triggerConf = new HashMap<String, Trigger>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private Database database;
    private Collection root;
    private DatabaseInstanceManager manager;
    private XPathQueryService queryService;
    private CollectionManagementService colman;
    private String configFile;
    private String backupDir;

    public void start() {
        log.info((Object)"starting database");
        try {
            if (this.getDatabase() == null) {
                this.setDatabase((Database)new DatabaseImpl());
                this.getDatabase().setProperty("configuration", this.getConfigFile());
                this.getDatabase().setProperty("create-database", "true");
            }
            DatabaseManager.registerDatabase((Database)this.getDatabase());
            this.setRoot(DatabaseManager.getCollection((String)("xmldb:exist://" + this.getRootCollection()), (String)"admin", (String)""));
            this.setManager((DatabaseInstanceManager)this.getRoot().getService("DatabaseInstanceManager", "1.0"));
            this.setQueryService((XPathQueryService)this.getRoot().getService("XPathQueryService", "1.0"));
            this.setColman((CollectionManagementService)this.getRoot().getService("CollectionManagementService", "1.0"));
            for (Map.Entry<String, Trigger> entry : this.getTriggerConf().entrySet()) {
                this.registerTrigger(entry.getValue(), entry.getKey());
            }
        }
        catch (XMLDBException e) {
            throw new IllegalStateException("cannot open eXist database", e);
        }
    }

    protected Collection getCollection(String collection) throws XMLDBException {
        this.readLock.lock();
        try {
            if (!collection.startsWith("/db")) {
                throw new XMLDBException(0, "collection path should begin with /db");
            }
            Collection collection2 = this.database.getCollection("exist://" + collection, "admin", "");
            return collection2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String name, String collection, String content) throws XMLDBException {
        this.writeLock.lock();
        try {
            if ("".equals(name)) {
                throw new XMLDBException(0, "cannot create a xml file with an empty file name");
            }
            Collection col = this.getCollection(collection);
            if (col == null) {
                this.createCollection(collection, true);
                col = this.getCollection(collection);
            }
            Resource res = col.createResource(name, XMLRESOURCE);
            res.setContent((Object)content);
            col.storeResource(res);
            ((EXistResource)res).freeResources();
            col.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name, String collection) throws XMLDBException {
        this.writeLock.lock();
        try {
            Collection col = this.getCollection(collection);
            Resource res = col.getResource(name);
            if (res == null) {
                boolean bl = false;
                return bl;
            }
            col.removeResource(res);
            col.close();
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String name, String collection, String content) throws XMLDBException {
        this.writeLock.lock();
        try {
            Collection col = this.getCollection(collection);
            Resource res = col.getResource(name);
            if (res == null) {
                throw new XMLDBException(0, "resource doesn't exist");
            }
            res.setContent((Object)content);
            col.storeResource(res);
            ((EXistResource)res).freeResources();
            col.close();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(String name, String collection) throws XMLDBException {
        this.readLock.lock();
        try {
            String string;
            Collection coll;
            block15: {
                Resource res;
                block13: {
                    String string2;
                    block14: {
                        block11: {
                            String string3;
                            block12: {
                                res = null;
                                coll = this.getCollection(collection);
                                try {
                                    if (coll != null) break block11;
                                    string3 = null;
                                    if (res == null) break block12;
                                }
                                catch (Throwable throwable) {
                                    if (res != null) {
                                        ((EXistResource)res).freeResources();
                                    }
                                    coll.close();
                                    throw throwable;
                                }
                                ((EXistResource)res).freeResources();
                            }
                            coll.close();
                            return string3;
                        }
                        res = coll.getResource(name);
                        if (res == null) break block13;
                        string2 = (String)res.getContent();
                        if (res == null) break block14;
                        ((EXistResource)res).freeResources();
                    }
                    coll.close();
                    return string2;
                }
                string = null;
                if (res == null) break block15;
                ((EXistResource)res).freeResources();
            }
            coll.close();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> xquery(String query) throws XMLDBException {
        this.readLock.lock();
        try {
            ResourceSet result = this.getQueryService().query(query);
            if (result == null) {
                Iterator<String> iterator = null;
                return iterator;
            }
            final ResourceIterator iterator = result.getIterator();
            Iterator<String> iterator2 = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    try {
                        return iterator.hasMoreResources();
                    }
                    catch (XMLDBException e) {
                        throw new RuntimeException("Error while getting next element", e);
                    }
                }

                @Override
                public String next() {
                    Resource res = null;
                    try {
                        res = iterator.nextResource();
                        String string = (String)res.getContent();
                        return string;
                    }
                    catch (XMLDBException e) {
                        throw new RuntimeException("Error while getting next element", e);
                    }
                    finally {
                        if (res != null) {
                            try {
                                ((EXistResource)res).freeResources();
                            }
                            catch (XMLDBException e) {
                                log.error((Object)"error on free resource");
                            }
                        }
                    }
                }
            };
            return iterator2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void xupdate(String query) throws XMLDBException {
        this.writeLock.lock();
        try {
            this.getQueryService().query(query);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void stop() {
        try {
            this.getManager().shutdown();
            DatabaseManager.deregisterDatabase((Database)this.database);
        }
        catch (XMLDBException e) {
            log.fatal((Object)"cannot close database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean collectionExists(String collection) throws XMLDBException {
        try (Collection col = null;){
            col = this.getCollection(collection);
            boolean bl = col != null;
            return bl;
        }
    }

    @Override
    public void createCollection(String collection) throws XMLDBException {
        this.writeLock.lock();
        try {
            this.createCollection(collection, false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void createCollection(String collection, boolean recursive) throws XMLDBException {
        XmldbURI uri;
        if (recursive && !this.collectionExists((uri = XmldbURI.create((String)collection).removeLastSegment()).toString())) {
            this.createCollection(uri.toString(), true);
        }
        this.getColman().createCollection(collection);
    }

    @Override
    public void removeCollection(String collection) throws XMLDBException {
        this.writeLock.lock();
        try {
            this.getColman().removeCollection(collection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public String getBackupDir() {
        return this.backupDir;
    }

    @Required
    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public boolean isRunning() {
        return false;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected void setDatabase(Database database) {
        this.database = database;
    }

    protected Collection getRoot() {
        return this.root;
    }

    protected void setRoot(Collection root) {
        this.root = root;
    }

    protected DatabaseInstanceManager getManager() {
        return this.manager;
    }

    protected void setManager(DatabaseInstanceManager manager) {
        this.manager = manager;
    }

    protected XPathQueryService getQueryService() {
        return this.queryService;
    }

    protected void setQueryService(XPathQueryService queryService) {
        this.queryService = queryService;
    }

    protected CollectionManagementService getColman() {
        return this.colman;
    }

    protected void setColman(CollectionManagementService colman) {
        this.colman = colman;
    }

    @Override
    public String getRootCollection() {
        return "/db";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listChildCollections(String collection) throws XMLDBException {
        this.readLock.lock();
        try {
            Collection col = this.getCollection(collection);
            if (col == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            List<String> list = Arrays.asList(col.listChildCollections());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(String collection) throws XMLDBException {
        this.readLock.lock();
        try {
            Collection col = this.getCollection(collection);
            if (col == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            List<String> list = Arrays.asList(col.listResources());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setExistTrigger(Class<?> triggerClass, String collection, List<String> events, Map<String, String> parameters) throws XMLDBException {
        StringBuilder conf = new StringBuilder();
        conf.append("<exist:collection xmlns:exist=\"http://exist-db.org/collection-config/1.0\"><exist:triggers>");
        String className = triggerClass.getCanonicalName();
        conf.append("<exist:trigger event=\"store,update,remove\" class=\"" + className + "\">");
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                conf.append("<exist:parameter name=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\"/>");
            }
        }
        conf.append("</exist:trigger>");
        conf.append("</exist:triggers></exist:collection>");
        log.info((Object)conf.toString());
        this.createCollection("/db/system/config" + collection, true);
        this.create(CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.toString(), "/db/system/config" + collection, conf.toString());
    }

    @Override
    public void registerTrigger(Trigger trigger, String collection) throws XMLDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("triggerName", trigger.getName());
        ExistTriggerRegistry.defaultInstance().registerTrigger(trigger.getName(), trigger);
        this.setExistTrigger(DelegatingDiffTrigger.class, collection, Arrays.asList("store", "update", "delete"), params);
    }

    public Map<String, Trigger> getTriggerConf() {
        return this.triggerConf;
    }

    public void setTriggerConf(Map<String, Trigger> triggerConf) {
        this.triggerConf = triggerConf;
    }

    @Override
    public String backup() throws XMLDBException, DatabaseConfigurationException {
        log.info((Object)"Starting backup...");
        this.readLock.lock();
        try {
            this.verifyBackupDir();
            String seq = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.backupDir + "/data-" + seq + ".zip"));
            FileWriter logFile = new FileWriter(this.backupDir + "/report-" + seq + ".log");
            logFile.write("Backup started at: " + DateUtils.now_ISO8601() + "\n\n");
            this.backup(this.getRoot().getName(), zip, logFile);
            logFile.write("\nBackup finished at: " + DateUtils.now_ISO8601() + "\n");
            logFile.flush();
            logFile.close();
            zip.flush();
            zip.close();
            log.info((Object)"Backup finished");
            String string = this.backupDir;
            return string;
        }
        catch (Exception e) {
            log.error((Object)"Backup failed", (Throwable)e);
            throw new XMLDBException(0, "cannot backup", (Throwable)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyBackupDir() {
        File d = new File(this.backupDir);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backup(String coll, ZipOutputStream zip, FileWriter logFile) throws XMLDBException, IOException {
        this.readLock.lock();
        logFile.write("COLLECTION: " + coll + "\n");
        log.info((Object)("Backup of collection " + coll));
        try {
            for (String file : this.list(coll)) {
                zip.putNextEntry(new ZipEntry(coll + "/" + file + ".xml"));
                Resource resource = this.getCollection(coll).getResource(file);
                zip.write(resource.getContent().toString().getBytes());
                zip.closeEntry();
            }
            for (String c : this.listChildCollections(coll)) {
                this.backup(coll + "/" + c, zip, logFile);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }
}

