/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.is.registry.schema.OpaqueResourceValidator;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.is.store.ISStore;
import eu.dnetlib.enabling.is.store.ISStoreException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.XQueryUtils;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class BulkResourceImporter {
    private XQueryUtils xqueryUtils;
    private UniqueServiceLocator serviceLocator;
    private OpaqueResourceValidator resourceValidator;
    private boolean validating = true;
    private boolean enabled = true;
    @Autowired
    private ISStore isStore;

    public void importResource(OpaqueResource resource) throws ISRegistryException {
        try {
            if (this.validating) {
                this.resourceValidator.validate(resource);
            }
            this.isStore.insertXML(this.xqueryUtils.getFileName(resource), this.xqueryUtils.getCollectionAbsPath(resource), resource.asString());
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)((Object)e));
        }
        catch (ValidationException e) {
            throw new ISRegistryException((Throwable)e);
        }
    }

    public XQueryUtils getXqueryUtils() {
        return this.xqueryUtils;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    @Required
    public void setResourceValidator(OpaqueResourceValidator resourceValidator) {
        this.resourceValidator = resourceValidator;
    }

    public OpaqueResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

