/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateNotificationDetector;
import eu.dnetlib.enabling.tools.DOMOpaqueResource;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.xml.database.LoggingTrigger;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;

public class NotificationTriggerImpl
extends LoggingTrigger {
    private static final Log log = LogFactory.getLog(NotificationTriggerImpl.class);
    private ResourceStateNotificationDetector<OpaqueResource> detector;
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    @Override
    public void created(String file, String collection, Document newDoc) {
        super.created(file, collection, newDoc);
        try {
            this.getDetector().resourceCreated((OpaqueResource)new DOMOpaqueResource(newDoc, this.saxonTransformerFactory));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    @Override
    public void deleted(String file, String collection, Document oldDoc) {
        super.deleted(file, collection, oldDoc);
        try {
            this.getDetector().resourceDeleted((OpaqueResource)new DOMOpaqueResource(oldDoc, this.saxonTransformerFactory));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    @Override
    public void updated(String file, String collection, Document oldDoc, Document newDoc) {
        super.updated(file, collection, oldDoc, newDoc);
        try {
            this.getDetector().resourceUpdated((OpaqueResource)new DOMOpaqueResource(oldDoc, this.saxonTransformerFactory), (OpaqueResource)new DOMOpaqueResource(newDoc, this.saxonTransformerFactory));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    public ResourceStateNotificationDetector<OpaqueResource> getDetector() {
        return this.detector;
    }

    public void setDetector(ResourceStateNotificationDetector<OpaqueResource> detector) {
        this.detector = detector;
    }

    public TransformerFactory getSaxonTransformerFactory() {
        return this.saxonTransformerFactory;
    }

    public void setSaxonTransformerFactory(TransformerFactory saxonTransformerFactory) {
        this.saxonTransformerFactory = saxonTransformerFactory;
    }
}

