/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.AbstractNotificationDetector;
import eu.dnetlib.enabling.is.sn.NotificationMessage;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateNotificationDetector;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionRegistry;
import eu.dnetlib.enabling.tools.OpaqueResource;
import java.io.StringWriter;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Node;

public class NotificationDetectorImpl
extends AbstractNotificationDetector
implements ResourceStateNotificationDetector<OpaqueResource> {
    private static final Log log = LogFactory.getLog(NotificationDetectorImpl.class);
    private Collection<ResourceStateSubscriptionRegistry> registries;
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    @Override
    public void resourceCreated(OpaqueResource newResource) {
        log.debug((Object)("resource created: " + this.registries));
        this.registries.forEach(registry -> {
            Collection<ResourceStateSubscription> subs = registry.listMatchingSubscriptions("CREATE", newResource.getResourceType(), newResource.getResourceId());
            subs.stream().filter(sub -> this.matchPath(newResource, sub.getXpath())).forEach(sub -> this.send((ResourceStateSubscription)sub, newResource, "CREATE"));
        });
    }

    private void send(ResourceStateSubscription sub, OpaqueResource resource, String prefix) {
        log.debug((Object)("RESOURCE " + resource));
        log.debug((Object)("id: " + resource.getResourceId()));
        log.debug((Object)("dom: " + resource.asDom()));
        StringBuffer topicBuffer = new StringBuffer();
        if (sub.getPrefix() == null && "*".equals(sub.getPrefix())) {
            topicBuffer.append(prefix);
        } else {
            topicBuffer.append(sub.getPrefix());
        }
        topicBuffer.append('.');
        topicBuffer.append(sub.getType());
        topicBuffer.append('.');
        topicBuffer.append(sub.getResourceId());
        if (sub.getXpath() != null && !sub.getXpath().isEmpty()) {
            topicBuffer.append(sub.getXpath().replace('/', '.'));
        }
        this.getSender().send(sub.getSubscriberAsEpr(), new NotificationMessage(sub.getSubscriptionId(), topicBuffer.toString(), resource.getResourceId(), resource.asString()));
    }

    @Override
    public void resourceDeleted(OpaqueResource oldResource) {
        log.debug((Object)("resource deleted: " + this.registries));
        this.registries.forEach(registry -> {
            Collection<ResourceStateSubscription> subs = registry.listMatchingSubscriptions("DELETE", oldResource.getResourceType(), oldResource.getResourceId());
            subs.stream().filter(sub -> this.matchPath(oldResource, sub.getXpath())).forEach(sub -> this.send((ResourceStateSubscription)sub, oldResource, "DELETE"));
        });
    }

    @Override
    public void resourceUpdated(OpaqueResource oldResource, OpaqueResource newResource) {
        log.debug((Object)("resource updated: " + this.registries));
        this.registries.forEach(registry -> {
            Collection<ResourceStateSubscription> subs = registry.listMatchingSubscriptions("UPDATE", oldResource.getResourceType(), oldResource.getResourceId());
            subs.stream().filter(sub -> this.comparePath(oldResource, newResource, sub.getXpath())).forEach(sub -> {
                log.debug((Object)("updated, sending: " + newResource.asString()));
                this.send((ResourceStateSubscription)sub, newResource, "UPDATE");
            });
        });
    }

    private boolean matchPath(OpaqueResource resource, String xpath) {
        if (xpath == null || xpath.isEmpty()) {
            return true;
        }
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            return !xpa.evaluate(xpath, resource.asDom()).isEmpty();
        }
        catch (XPathExpressionException e) {
            log.warn((Object)"wrong xpath expression, notification possibly missed", (Throwable)e);
            return false;
        }
    }

    private boolean comparePath(OpaqueResource oldResource, OpaqueResource newResource, String xpath) {
        if (oldResource == null || newResource == null || xpath == null || xpath.isEmpty()) {
            return true;
        }
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            Transformer transformer = this.saxonTransformerFactory.newTransformer();
            Node left = (Node)xpa.evaluate(xpath, oldResource.asDom(), XPathConstants.NODE);
            Node right = (Node)xpa.evaluate(xpath, newResource.asDom(), XPathConstants.NODE);
            if (left == null || right == null) {
                if (left != null) {
                    return true;
                }
                return right != null;
            }
            StringWriter leftWriter = new StringWriter();
            StringWriter rightWriter = new StringWriter();
            transformer.transform(new DOMSource(left), new StreamResult(leftWriter));
            transformer.transform(new DOMSource(right), new StreamResult(rightWriter));
            return !leftWriter.toString().equals(rightWriter.toString());
        }
        catch (XPathExpressionException e) {
            log.warn((Object)"wrong xpath expression, notification possibly missed", (Throwable)e);
        }
        catch (TransformerException e) {
            log.warn((Object)"serialization problem", (Throwable)e);
        }
        return false;
    }

    public Collection<ResourceStateSubscriptionRegistry> getRegistries() {
        return this.registries;
    }

    public void setRegistries(Collection<ResourceStateSubscriptionRegistry> registries) {
        this.registries = registries;
    }
}

