/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry.schema;

import eu.dnetlib.enabling.is.registry.schema.OpaqueResourceValidator;
import eu.dnetlib.enabling.is.registry.schema.ResourceSchemaDAO;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.tools.OpaqueResource;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class OpaqueResourceValidatorImpl
implements OpaqueResourceValidator {
    private ResourceSchemaDAO schemaDao;

    public void validate(OpaqueResource resource) throws ValidationException {
        Schema schema = this.getSchemaDao().getResourceSchema(resource.getResourceType());
        if (schema == null) {
            throw new ValidationException("no registered schema for " + resource.getResourceType());
        }
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(resource.asString())));
        }
        catch (SAXException e) {
            throw new ValidationException((Throwable)e);
        }
        catch (IOException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    public ResourceSchemaDAO getSchemaDao() {
        return this.schemaDao;
    }

    public void setSchemaDao(ResourceSchemaDAO schemaDao) {
        this.schemaDao = schemaDao;
    }
}

