/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry.schema;

import eu.dnetlib.enabling.is.registry.schema.ResourceSchemaDAO;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class ResourceSchemaDAOImpl
implements ResourceSchemaDAO {
    private ISLookUpService isLookup;
    private static final Log log = LogFactory.getLog(ResourceSchemaDAOImpl.class);

    @Override
    public Schema getResourceSchema(String resourceType) {
        try {
            String schemaSource = this.isLookup.getResourceTypeSchema(resourceType);
            if (schemaSource == null || schemaSource.isEmpty()) {
                log.warn((Object)("cannot find resource type " + resourceType));
                return null;
            }
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(new StringReader(schemaSource)));
        }
        catch (ISLookUpException e) {
            log.warn((Object)("cannot find resource type" + resourceType), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            log.fatal((Object)"cannot parse resource type schema", (Throwable)e);
            return null;
        }
    }

    public ISLookUpService getIsLookup() {
        return this.isLookup;
    }

    @Required
    public void setIsLookup(ISLookUpService isLookup) {
        this.isLookup = isLookup;
    }
}

