/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import eu.dnetlib.enabling.is.registry.NoSuchPendingCategoryException;
import eu.dnetlib.enabling.is.registry.ResourceKindResolver;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ApplicationProfileResourceKindResolver
implements ResourceKindResolver {
    private Document appProfile;

    public ApplicationProfileResourceKindResolver() {
        try {
            this.appProfile = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getClass().getResourceAsStream("DRIVERInformationSpaceApplicationProfile.xml"));
        }
        catch (SAXException e) {
            throw new IllegalStateException("cannot parse information space application profile", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot parse information space application profile", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("cannot parse information space application profile", e);
        }
    }

    @Override
    public String getNormalKindForType(String resourceType) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String res = xpath.evaluate("//RESOURCE_TYPE[text() = '" + resourceType + "']/../../RESOURCE_KIND", this.appProfile);
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public String getPendingKindForType(String resourceType) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String res = xpath.evaluate("//RESOURCE_TYPE[text() = '" + resourceType + "']/../../PENDING_TYPOLOGY", this.appProfile);
        if (res.isEmpty()) {
            throw new NoSuchPendingCategoryException("no pending category for " + resourceType);
        }
        return res;
    }
}

