package eu.dnetlib.data.mdstore.plugins.objects;

import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(XmlAccessType.FIELD)
public class Author {

	@XmlValue
	private String name;

	@XmlAttribute(name = "orcid")
	private String orcid;

	public Author() {}

	public Author(final String name) {
		this.name = name;
	}

	public Author(final String name, final String orcid) {
		this.name = name;
		this.orcid = orcid;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getOrcid() {
		return orcid;
	}

	public void setOrcid(final String orcid) {
		this.orcid = orcid;
	}

	@Override
	public int hashCode() {
		return Objects.hash(name);
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (!(obj instanceof Author)) { return false; }
		final Author other = (Author) obj;
		return Objects.equals(name, other.name) && Objects.equals(orcid, other.orcid);
	}
}
