/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.google.common.net.UrlEscapers;
import eu.dnetlib.data.mdstore.plugins.MdRecordPlugin;
import eu.dnetlib.data.mdstore.plugins.objects.Author;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MyURL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;

public class EnrichLocalLinksPlugin
extends MdRecordPlugin {
    private static final String DEFAULT_RIGHTS = "Open Access";
    private static final String INFO_FILENAME = "info.txt";
    private static final Log log = LogFactory.getLog(EnrichLocalLinksPlugin.class);
    private FTPClient ftpClient;
    private String hostedBy;
    private String baseUrl;
    private String ftpServer;
    private String ftpUser;
    private String ftpPassword;
    private String ftpBaseDir;
    private boolean ftpSecure = false;

    @Override
    protected void reconfigure(Map<String, String> params) {
        this.setHostedBy(params.get("hostedBy"));
        this.setBaseUrl(params.get("baseUrl"));
        this.setFtpServer(params.get("ftpServer"));
        this.setFtpUser(params.get("ftpUser"));
        this.setFtpPassword(params.get("ftpPassword"));
        this.setFtpBaseDir(params.get("ftpBaseDir"));
        this.setFtpSecure(params.containsKey("ftpSecure") && params.get("ftpSecure").equalsIgnoreCase("true"));
        if (!this.getFtpBaseDir().startsWith("/")) {
            this.setFtpBaseDir("/" + this.getFtpBaseDir());
        }
        try {
            if (this.isFtpSecure()) {
                this.ftpClient = new FTPSClient();
                this.ftpClient.connect(this.getFtpServer());
                ((FTPSClient)this.ftpClient).execPBSZ(0L);
                ((FTPSClient)this.ftpClient).execPROT("P");
            } else {
                this.ftpClient = new FTPClient();
                this.ftpClient.connect(this.getFtpServer());
            }
            if (!this.ftpClient.login(this.getFtpUser(), this.getFtpPassword())) {
                throw new RuntimeException("FTP login failed");
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setBufferSize(1024);
            log.debug((Object)("Connected to " + this.ftpServer));
        }
        catch (IOException e) {
            log.error((Object)"Connection Failed");
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void resetConfiguration() {
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
                log.debug((Object)("Disconnected from " + this.ftpServer));
            }
            catch (IOException e) {
                log.error((Object)"Disconnection Failed");
                throw new RuntimeException(e);
            }
        }
        this.setHostedBy(null);
        this.setBaseUrl(null);
        this.setFtpServer(null);
        this.setFtpUser(null);
        this.setFtpPassword(null);
        this.setFtpBaseDir(null);
        this.setFtpClient(null);
        this.setFtpSecure(false);
    }

    @Override
    protected boolean updateRecord(String recordId, MdRecord doc) {
        int year = doc.getDate();
        String code = StringUtils.substringAfterLast((String)doc.getId(), (String)":");
        log.debug((Object)String.format("Processing record: %s (%s/%s)", doc.getId(), year, code));
        List<String> files = this.touchAndListDir(doc.getTitle(), doc.getCreators(), doc.getType(), year, code);
        if (files.isEmpty()) {
            return false;
        }
        log.debug((Object)("  - adding new urls: " + files.size()));
        doc.setBestRights(DEFAULT_RIGHTS);
        for (String f : files) {
            doc.getUrls().add(new MyURL(this.calculateUrl(recordId, code, year, f), this.getHostedBy(), DEFAULT_RIGHTS));
        }
        return true;
    }

    private List<String> touchAndListDir(String title, Set<Author> authors, String type, int year, String code) {
        String content = String.format("TITLE     : %s\nAUTHOR(S) : %s\nTYPE      : %s\nYEAR      : %s\nCODE      : %s\n\n*** DO NOT EDIT THIS FILE ***\n\n", title, authors.stream().map(Author::getName).collect(Collectors.joining(", ")), type, year, code);
        if (this.ftpChangeDir(this.getFtpBaseDir()) && this.ftpChangeDir(Integer.toString(year)) && this.ftpChangeDir(code)) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());){
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format(" - Saving file %s/%s/%s/%s", this.getFtpBaseDir(), year, code, INFO_FILENAME));
                    log.debug((Object)content);
                }
                if (!this.ftpClient.storeFile(INFO_FILENAME, (InputStream)is)) {
                    log.error((Object)("Error saving file: " + this.ftpClient.getReplyCode() + " - " + this.ftpClient.getReplyString()));
                    throw new RuntimeException("Error saving file: " + this.ftpClient.getReplyString());
                }
            }
            catch (IOException e) {
                log.error((Object)"Error saving info file");
                throw new RuntimeException("Error saving info file", e);
            }
            try {
                return Arrays.stream(this.ftpClient.listFiles()).map(FTPFile::getName).filter(s -> s.toLowerCase().endsWith(".pdf")).sorted().collect(Collectors.toList());
            }
            catch (IOException e) {
                log.error((Object)"Error listing files");
                throw new RuntimeException("Error listing files", e);
            }
        }
        log.error((Object)String.format("Directory not found: %s/%s/%s", this.getFtpBaseDir(), year, code));
        throw new RuntimeException(String.format("Directory not found: %s/%s/%s", this.getFtpBaseDir(), year, code));
    }

    private boolean ftpChangeDir(String dir) {
        try {
            if (!this.ftpClient.changeWorkingDirectory(dir)) {
                this.ftpClient.makeDirectory(dir);
                return this.ftpClient.changeWorkingDirectory(dir);
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)("Error changing or create dir: " + dir));
            throw new RuntimeException("Error changing or create dir: " + dir, e);
        }
    }

    private String calculateUrl(String id, String code, int year, String f) {
        return String.format("%s/%s/%s/%s?id=%s", this.getBaseUrl(), year, code, UrlEscapers.urlPathSegmentEscaper().escape(f), UrlEscapers.urlFormParameterEscaper().escape(id));
    }

    public String getHostedBy() {
        return this.hostedBy;
    }

    public void setHostedBy(String hostedBy) {
        this.hostedBy = hostedBy;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getFtpBaseDir() {
        return this.ftpBaseDir;
    }

    public void setFtpBaseDir(String ftpBaseDir) {
        this.ftpBaseDir = ftpBaseDir;
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public void setFtpServer(String ftpServer) {
        this.ftpServer = ftpServer;
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpUser(String ftpUser) {
        this.ftpUser = ftpUser;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setFtpPassword(String ftpPassword) {
        this.ftpPassword = ftpPassword;
    }

    public boolean isFtpSecure() {
        return this.ftpSecure;
    }

    public void setFtpSecure(boolean ftpSecure) {
        this.ftpSecure = ftpSecure;
    }
}

