/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.google.common.base.Splitter;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.plugins.Counter;
import eu.dnetlib.data.mdstore.plugins.GenericDoiMdstorePlugin;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MyURL;
import eu.dnetlib.data.mdstore.plugins.objects.Project;
import eu.dnetlib.data.utils.XsltFunctions;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EnrichOpenairePlugin
extends GenericDoiMdstorePlugin {
    private static final Log log = LogFactory.getLog(EnrichOpenairePlugin.class);
    @Value(value="${plugin.enrich.publications.openaire.url}")
    private String baseUrl;
    @Value(value="${plugin.enrich.openaire.datasources.blacklist}")
    private String datasourceBlackList;
    @Autowired
    private MongoClient mongoClient;
    private Map<String, Counter> counters = new HashMap<String, Counter>();

    @Override
    protected URI prepareURI(String doi) throws URISyntaxException {
        return new URI(String.format(this.baseUrl, doi));
    }

    @Override
    protected MongoCollection<Document> getCacheCollection() {
        return this.mongoClient.getDatabase("API_CACHES").getCollection("OPENAIRE_API_CACHE");
    }

    @Override
    protected void reconfigure(Map<String, String> params) {
        this.counters.clear();
        this.counters.put("subjects", new Counter());
        this.counters.put("citations", new Counter());
        this.counters.put("urls", new Counter());
        this.counters.put("projects", new Counter());
        this.counters.put("dois", new Counter());
    }

    @Override
    protected void resetConfiguration() {
        log.info((Object)("***** Openaire Enrichment - subjects  : " + this.counters.get("subjects")));
        log.info((Object)("***** Openaire Enrichment - citations : " + this.counters.get("citations")));
        log.info((Object)("***** Openaire Enrichment - urls      : " + this.counters.get("urls")));
        log.info((Object)("***** Openaire Enrichment - projects  : " + this.counters.get("projects")));
        log.info((Object)("***** Openaire Enrichment - dois      : " + this.counters.get("dois")));
        this.counters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateDocument(MdRecord doc, String response) {
        this.counters.get("subjects").incrementBefore(doc.getSubjects().size());
        this.counters.get("citations").incrementBefore(doc.getCitations().size());
        this.counters.get("urls").incrementBefore(doc.getUrls().size());
        this.counters.get("projects").incrementBefore(doc.getProjects().size());
        this.counters.get("dois").incrementBefore(doc.getDois().size());
        try {
            org.dom4j.Document docRes = new SAXReader().read((Reader)new StringReader(response));
            List results = docRes.selectNodes("/response/results/result");
            if (results.size() == 1) {
                Node n = (Node)results.get(0);
                this.updateSubjects(doc, n);
                this.updateCitations(doc, n);
                this.updateUrls(doc, n);
                this.updateProjects(doc, n);
                this.updateDois(doc, n);
                this.updateBestRights(doc);
                boolean bl = true;
                return bl;
            }
            if (results.size() == 1) {
                log.warn((Object)"Too many responses");
            }
        }
        catch (DocumentException e) {
            log.warn((Object)"Invalid response", (Throwable)e);
        }
        finally {
            this.counters.get("subjects").incrementAfter(doc.getSubjects().size());
            this.counters.get("citations").incrementAfter(doc.getCitations().size());
            this.counters.get("urls").incrementAfter(doc.getUrls().size());
            this.counters.get("projects").incrementAfter(doc.getProjects().size());
            this.counters.get("dois").incrementAfter(doc.getDois().size());
        }
        return false;
    }

    private void updateSubjects(MdRecord doc, Node n) {
        Set<String> subjects = doc.getSubjects().stream().map(EnrichOpenairePlugin::cleanSubject).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Object o : n.selectNodes(".//subject[@classid='keyword']")) {
            subjects.addAll(EnrichOpenairePlugin.cleanSubject(((Node)o).getText().trim()));
        }
        doc.setSubjects(subjects);
    }

    public static List<String> cleanSubject(String s) {
        if (s.isEmpty()) {
            return new ArrayList<String>();
        }
        if (s.startsWith("info:eu-repo/classification/msc/")) {
            return new ArrayList<String>();
        }
        if (s.startsWith("info:eu-repo/classification/acm/")) {
            return Arrays.asList(s.replaceFirst("info:eu-repo/classification/acm/", ""));
        }
        if (s.contains(";")) {
            return Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)s);
        }
        if (s.contains(",")) {
            return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)s);
        }
        return Arrays.asList(s);
    }

    private void updateCitations(MdRecord doc, Node n) {
        doc.getCitations().clear();
        for (Object o : n.selectNodes(".//citations/citation/rawText")) {
            doc.getCitations().add(((Node)o).getText());
        }
        for (Object o : n.selectNodes(".//references/reference/rawText")) {
            doc.getCitations().add(((Node)o).getText());
        }
    }

    private void updateUrls(MdRecord doc, Node n) {
        doc.getUrls().addAll(doc.getUrls());
        Set blacklist = Arrays.stream(this.datasourceBlackList.split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        for (Object oin : n.selectNodes(".//instance")) {
            String hostedByid = ((Element)oin).valueOf("./hostedby/@id").trim();
            if (blacklist.contains(hostedByid)) continue;
            String hostedBy = ((Element)oin).valueOf("./hostedby/@name").trim();
            String rights = ((Element)oin).valueOf("./accessright/@classname").trim();
            for (Object ourl : ((Element)oin).selectNodes("./webresource/url")) {
                String url = ((Node)ourl).getText().trim();
                String name = hostedBy.equalsIgnoreCase("Unknown") || hostedBy.equalsIgnoreCase("Unknown Repository") ? XsltFunctions.serverName(url) : hostedBy;
                MyURL u = new MyURL(url, name, rights);
                doc.getUrls().remove(u);
                doc.getUrls().add(u);
            }
        }
    }

    private void updateProjects(MdRecord doc, Node n) {
        for (Object op : n.selectNodes(".//rels/rel[./to/@type='project']")) {
            Node p = (Node)op;
            String name = p.valueOf("./title").trim();
            if (!StringUtils.isNotBlank((CharSequence)name) || name.equalsIgnoreCase("null") || name.equalsIgnoreCase("unidentified") || name.equalsIgnoreCase("unknown")) continue;
            Project np = new Project();
            np.setOpenaireId(p.valueOf("./to"));
            np.setCode(p.valueOf("./code"));
            np.setName(name);
            np.setAcronym(p.valueOf("./acronym"));
            np.setFunder(p.valueOf(".//funder/@shortname"));
            np.setProgram(p.valueOf(".//funding_level_0/@name"));
            np.setJurisdiction(p.valueOf(".//funder/@jurisdiction"));
            np.setInfoId(XsltFunctions.projectLongId(np.getFunder(), np.getProgram(), np.getCode(), np.getJurisdiction(), np.getName(), np.getAcronym()));
            doc.getProjects().add(np);
        }
    }

    private void updateDois(MdRecord doc, Node n) {
        for (Object od : n.selectNodes(".//*[local-name()='result']/pid[@classid='doi']")) {
            String doi = XsltFunctions.cleanDoi(((Node)od).getText());
            if (!StringUtils.isNotBlank((CharSequence)doi)) continue;
            doc.getDois().add(doi);
        }
    }

    private void updateBestRights(MdRecord doc) {
        Set availables = doc.getUrls().stream().map(MyURL::getRights).map(String::toUpperCase).collect(Collectors.toSet());
        if (availables.contains("OPEN ACCESS")) {
            doc.setBestRights("Open Access");
        } else if (availables.contains("EMBARGO")) {
            doc.setBestRights("Embargo");
        } else if (availables.contains("RESTRICTED")) {
            doc.setBestRights("Restricted");
        } else if (availables.contains("CLOSED ACCESS")) {
            doc.setBestRights("Closed Access");
        } else {
            doc.setBestRights("Unknown");
        }
    }
}

