var module = angular.module('affiliationsUI', []);

module.controller('affiliationsCtrl', function ($scope, $http, $timeout, $sce) {
	initSpinner();

	$scope.affiliations = [];
	$scope.tempAffiliation = {};
	$scope.groups = [];
			
	$scope.refresh = function() {
		showSpinner();
					
		$scope.affiliations = [];
		$http.get('portal/aff_view').success(function(data) {
			hideSpinner();
			angular.forEach(data, function(persons, name) {
				$scope.affiliations.push({'name' : name, 'persons': persons});
			});
		}).error(function() {
			hideSpinner();
			show_notification("error","An error occurred while fetching affiliations");
		});
		
		$http.get('portal/groups').success(function(data) {
			$scope.groups = data;
		}).error(function() {
			show_notification("error","An error occurred while fetching groups");
		});
		
	}
		
	$scope.prepareTempAffiliation = function(pid, pname, year) {
		$scope.tempAffiliation = {
			'pid'   : pid,
			'pname' : pname,
			'year'  : year
		}
	}

	$scope.saveAffiliation = function(aff) {
		
		delete $scope.tempAffiliation['pname'];
		
		if (!aff.gid) {
			show_notification("error","Group not selected");
			return;
		}
		
		showSpinner();
		$http.post('portal/addAffiliation', aff).success(function(data) {
			hideSpinner();
			$scope.refresh();
		}).error(function() {
			hideSpinner();
			show_notification("error","An error occurred saving affiliations");
		});
	}
	
	$scope.refresh();
	
});

