package eu.dnetlib.data.db;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class DbPerson {

	private String id;
	private String fullname;
	private String orcid;
	private SortedMap<Integer, Set<DbGroup>> groups = new TreeMap<>();

	public DbPerson() {}

	public DbPerson(final String id, final String fullname, final String orcid) {
		this.id = id;
		this.fullname = fullname;
		this.orcid = orcid;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getFullname() {
		return fullname;
	}

	protected void setFullname(final String fullname) {
		this.fullname = fullname;
	}

	public SortedMap<Integer, Set<DbGroup>> getGroups() {
		return groups;
	}

	public void setGroups(final SortedMap<Integer, Set<DbGroup>> groups) {
		this.groups = groups;
	}

	public String getOrcid() {
		return orcid;
	}

	public void setOrcid(final String orcid) {
		this.orcid = orcid;
	}

	@Override
	public String toString() {
		return "Person [id=" + id + ", fullname=" + fullname + ", orcid=" + orcid + ", groups=" + groups + "]";
	}

}
