package eu.dnetlib.data.mdstore.plugins;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;

import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.utils.HttpFetcher;

public abstract class GenericDoiMdstorePlugin extends MdRecordPlugin {

	private static final Log log = LogFactory.getLog(GenericDoiMdstorePlugin.class);

	@Override
	protected final boolean updateRecord(final String recordId, final MdRecord record) {
		for (final String doi : record.getDois()) {
			log.debug("  Record " + record.getId() + " has doi " + doi);
			final String response = obtainData(doi);
			if ((response != null) && updateDocument(record, response)) { return true; }
		}
		return false;
	}

	abstract protected boolean updateDocument(MdRecord doc, String response);

	abstract protected URI prepareURI(String doi) throws URISyntaxException;

	abstract protected MongoCollection<Document> getCacheCollection();

	private String obtainData(final String doi) {
		final MongoCollection<Document> cacheColl = getCacheCollection();

		final Document row = cacheColl.find(new BasicDBObject("doi", doi)).first();
		if (row != null) {
			return row.get("data") != null ? row.get("data").toString() : null;
		} else {
			final String res = download(doi);

			final Document doc = new Document();
			doc.append("doi", doi);
			doc.append("data", res);
			cacheColl.insertOne(doc);

			return res;
		}
	}

	private String download(final String doi) {
		try {
			return HttpFetcher.fetch(prepareURI(doi));
		} catch (final URISyntaxException e) {
			log.error("Error resolving doi: " + doi, e);
			return null;
		}
	}

}
