package eu.dnetlib.data.mdstore.plugins.objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(XmlAccessType.FIELD)
public class Dataset {

	@XmlAttribute(name = "doi")
	private String doi;

	@XmlAttribute(name = "url")
	private String url;

	@XmlValue
	private String title;

	public Dataset() {}

	public Dataset(final String doi, final String title) {
		this.doi = doi;
		this.title = title;
		setUrl("https://dx.doi.org/" + doi);
	}

	public Dataset(final String doi, final String url, final String title) {
		this.doi = doi;
		this.url = url;
		this.title = title;
	}

	public String getDoi() {
		return doi;
	}

	public void setDoi(final String doi) {
		this.doi = doi;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(final String url) {
		this.url = url;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	@Override
	public int hashCode() {
		return doi.toLowerCase().hashCode();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) { return true; }
		if (obj == null) { return false; }
		return (obj instanceof Dataset) && doi.equalsIgnoreCase(((Dataset) obj).getDoi());
	}

}
