package eu.dnetlib.data.mdstore.plugins.objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(XmlAccessType.FIELD)
public class MyURL {

	@XmlValue
	private String url;

	@XmlAttribute(name = "hostedBy")
	private String hostedBy;

	@XmlAttribute(name = "rights")
	private String rights;

	public MyURL() {}

	public MyURL(final String url, final String hostedBy, final String rights) {
		this.url = url;
		this.hostedBy = hostedBy;
		this.rights = rights;
	}

	public String getUrl() {
		return url;
	}

	public String getHostedBy() {
		return hostedBy;
	}

	public String getRights() {
		return rights;
	}

	public void setUrl(final String url) {
		this.url = url;
	}

	public void setHostedBy(final String hostedBy) {
		this.hostedBy = hostedBy;
	}

	public void setRights(final String rights) {
		this.rights = rights;
	}

	@Override
	public int hashCode() {
		return url.replaceAll("https://", "http://").hashCode();
	}

	@Override
	public boolean equals(final Object obj) {
		if ((obj != null) && (obj instanceof MyURL)) {
			final String url1 = url.replaceAll("https://", "http://");
			final String url2 = ((MyURL) obj).getUrl().replaceAll("https://", "http://");
			return url1.equals(url2);
		}
		return false;
	}
}
