/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.db;

import eu.dnetlib.data.db.DbGroup;
import eu.dnetlib.data.db.DbPerson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbPersonsDao {
    private JdbcTemplate jdbcTemplate;

    public List<DbPerson> listPersonsWithAffiliations() {
        HashMap<String, DbPerson> temp = new HashMap<String, DbPerson>();
        for (Map map : this.jdbcTemplate.queryForList("select * from affiliations_view")) {
            String pid = (String)map.get("pid");
            Integer year = (Integer)map.get("year");
            DbGroup group = new DbGroup((String)map.get("gid"), (String)map.get("gname"), (String)map.get("gtype"));
            temp.putIfAbsent(pid, new DbPerson(pid, (String)map.get("pfullname"), (String)map.get("orcid")));
            if (year == null) continue;
            ((DbPerson)temp.get(pid)).getGroups().putIfAbsent(year, new TreeSet((g1, g2) -> {
                int n2;
                int n1 = this.calculateIntegerForGroup(g1.getType());
                return n1 == (n2 = this.calculateIntegerForGroup(g2.getType())) ? g1.getId().compareTo(g2.getId()) : Integer.compare(n1, n2);
            }));
            ((Set)((DbPerson)temp.get(pid)).getGroups().get(year)).add(group);
        }
        return temp.values().stream().sorted((p1, p2) -> p1.getFullname().compareTo(p2.getFullname())).collect(Collectors.toList());
    }

    public Map<String, String> obtainRawPersonToMasterRels() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map map : this.jdbcTemplate.queryForList("select raw_id, master_id from raw_persons where master_id is not null")) {
            String rawId = (String)map.get("raw_id");
            String masterId = "dnet:pers:" + map.get("master_id");
            res.put(rawId, masterId);
        }
        return res;
    }

    private int calculateIntegerForGroup(String type) {
        if (type.equalsIgnoreCase("Laboratorio")) {
            return 0;
        }
        if (type.equalsIgnoreCase("Servizio")) {
            return 10;
        }
        if (type.equalsIgnoreCase("Centro")) {
            return 20;
        }
        return 100;
    }

    public void registerRawPerson(String code, String name, String surname, String suffix, String orcid) {
        this.jdbcTemplate.update("INSERT IGNORE INTO raw_persons(raw_id, name, surname, suffix, orcid) VALUES (?, ?, ?, ?, ?)", new Object[]{code, name, surname, suffix, orcid});
    }

    public void registerAffiliation(String pid, String gid, int year) {
        this.jdbcTemplate.update("INSERT IGNORE INTO affiliations(pid, gid, year) VALUES (?, ?, ?)", new Object[]{pid, gid, year});
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Required
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

