/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.plugins.MdRecordPlugin;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.utils.HttpFetcher;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class GenericDoiMdstorePlugin
extends MdRecordPlugin {
    private static final Log log = LogFactory.getLog(GenericDoiMdstorePlugin.class);

    @Override
    protected final boolean updateRecord(String recordId, MdRecord record) {
        for (String doi : record.getDois()) {
            log.debug((Object)("  Record " + record.getId() + " has doi " + doi));
            String response = this.obtainData(doi);
            if (response == null || !this.updateDocument(record, response)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean updateDocument(MdRecord var1, String var2);

    protected abstract URI prepareURI(String var1) throws URISyntaxException;

    protected abstract MongoCollection<Document> getCacheCollection();

    private String obtainData(String doi) {
        MongoCollection<Document> cacheColl = this.getCacheCollection();
        Document row = (Document)cacheColl.find((Bson)new BasicDBObject("doi", (Object)doi)).first();
        if (row != null) {
            return row.get((Object)"data") != null ? row.get((Object)"data").toString() : null;
        }
        String res = this.download(doi);
        Document doc = new Document();
        doc.append("doi", (Object)doi);
        doc.append("data", (Object)res);
        cacheColl.insertOne((Object)doc);
        return res;
    }

    private String download(String doi) {
        try {
            return HttpFetcher.fetch(this.prepareURI(doi));
        }
        catch (URISyntaxException e) {
            log.error((Object)("Error resolving doi: " + doi), (Throwable)e);
            return null;
        }
    }
}

