/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utils;

import eu.dnetlib.data.mdstore.plugins.objects.Author;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXFormatter;
import org.jbibtex.BibTeXObject;
import org.jbibtex.Key;
import org.jbibtex.StringValue;
import org.jbibtex.Value;

public class BibTexConverter {
    private static final Log log = LogFactory.getLog(BibTexConverter.class);

    public static String asBibTex(MdRecord record) {
        try {
            BibTeXEntry dbEntry = new BibTeXEntry(BibTexConverter.findBibTexType(record.getType()), new Key(record.getId()));
            BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_TITLE, record.getTitle());
            BibTexConverter.addMultipleAuthorValue(dbEntry, BibTeXEntry.KEY_AUTHOR, record.getCreators());
            BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_PUBLISHER, record.getPublisher());
            BibTexConverter.addMultipleStringValue(dbEntry, BibTeXEntry.KEY_DOI, record.getDois());
            BibTexConverter.addSourceAndDate(dbEntry, record);
            BibTeXFormatter formatter = new BibTeXFormatter();
            StringWriter res = new StringWriter();
            BibTeXDatabase db = new BibTeXDatabase();
            db.addObject((BibTeXObject)dbEntry);
            formatter.format(db, (Writer)res);
            return ((Object)res).toString();
        }
        catch (IOException e) {
            log.warn((Object)"Error generating bibtex", (Throwable)e);
            return "";
        }
    }

    private static void addSimpleStringValue(BibTeXEntry dbEntry, Key key, Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            dbEntry.addField(key, (Value)new StringValue(BibTexConverter.escapeString(value.toString()), StringValue.Style.BRACED));
        }
    }

    private static void addMultipleStringValue(BibTeXEntry dbEntry, Key key, Collection<String> list) {
        String val = list.stream().map(String::trim).filter(StringUtils::isNotBlank).map(BibTexConverter::escapeString).collect(Collectors.joining(" and "));
        if (StringUtils.isNotBlank((CharSequence)val)) {
            dbEntry.addField(key, (Value)new StringValue(val, StringValue.Style.BRACED));
        }
    }

    private static void addMultipleAuthorValue(BibTeXEntry dbEntry, Key key, Collection<Author> list) {
        String val = list.stream().map(Author::getName).map(String::trim).filter(StringUtils::isNotBlank).map(BibTexConverter::escapeString).collect(Collectors.joining(" and "));
        if (StringUtils.isNotBlank((CharSequence)val)) {
            dbEntry.addField(key, (Value)new StringValue(val, StringValue.Style.BRACED));
        }
    }

    private static String escapeString(String s) {
        return s.replaceAll("&", "\\\\&");
    }

    private static void addSourceAndDate(BibTeXEntry dbEntry, MdRecord record) {
        String year = Integer.toString(record.getDate());
        if (record.getSource() != null) {
            switch (record.getType().toLowerCase()) {
                case "conference article": 
                case "contribution to conference": {
                    BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_BOOKTITLE, record.getSource());
                    break;
                }
                case "contribution to book": {
                    BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_BOOKTITLE, record.getSource());
                    break;
                }
                case "report": {
                    BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_INSTITUTION, record.getSource());
                    break;
                }
                case "journal article": {
                    String regex = "^(.+) (\\d*) \\((\\d{4})\\)(: (\\d+\\\u2013?\\d*))?";
                    Pattern pattern = Pattern.compile("^(.+) (\\d*) \\((\\d{4})\\)(: (\\d+\\\u2013?\\d*))?");
                    Matcher matcher = pattern.matcher(record.getSource());
                    if (!matcher.find()) break;
                    if (matcher.groupCount() >= 1) {
                        BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_JOURNAL, matcher.group(1));
                    }
                    if (matcher.groupCount() >= 2) {
                        BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_VOLUME, matcher.group(2));
                    }
                    if (matcher.groupCount() >= 3) {
                        year = matcher.group(3);
                    }
                    if (matcher.groupCount() < 5) break;
                    BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_PAGES, matcher.group(5));
                    break;
                }
                case "patent": {
                    BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_HOWPUBLISHED, record.getSource());
                }
            }
        }
        BibTexConverter.addSimpleStringValue(dbEntry, BibTeXEntry.KEY_YEAR, year);
    }

    private static Key findBibTexType(String resourceType) {
        switch (resourceType.toLowerCase()) {
            case "conference article": 
            case "contribution to conference": {
                return BibTeXEntry.TYPE_INPROCEEDINGS;
            }
            case "report": {
                return BibTeXEntry.TYPE_TECHREPORT;
            }
            case "journal article": {
                return BibTeXEntry.TYPE_ARTICLE;
            }
            case "other": {
                return BibTeXEntry.TYPE_MISC;
            }
            case "contribution to book": {
                return BibTeXEntry.TYPE_INBOOK;
            }
            case "book": {
                return BibTeXEntry.TYPE_BOOK;
            }
            case "bachelor thesis": {
                return BibTeXEntry.TYPE_MASTERSTHESIS;
            }
            case "doctoral thesis": {
                return BibTeXEntry.TYPE_PHDTHESIS;
            }
            case "patent": {
                return BibTeXEntry.TYPE_MISC;
            }
            case "master thesis": {
                return BibTeXEntry.TYPE_MASTERSTHESIS;
            }
        }
        return BibTeXEntry.TYPE_MISC;
    }
}

