/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utils;

import eu.dnetlib.data.mdstore.plugins.objects.Project;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XsltFunctions {
    private static final Log log = LogFactory.getLog(XsltFunctions.class);

    public static String cleanNames(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        return XsltFunctions.cleanNames(s, StringUtils.countMatches((CharSequence)s, (CharSequence)",") > 1 ? "," : ";");
    }

    public static String extractYear(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return "";
        }
        Matcher m = Pattern.compile("^.*(\\d{4}).*$").matcher(s);
        return m.matches() ? m.group(1) : "";
    }

    private static String cleanNames(String s, String sep) {
        return Arrays.stream(s.split(sep)).map(String::trim).map(XsltFunctions::clean).map(XsltFunctions::capitalize).filter(StringUtils::isNotBlank).collect(Collectors.joining("#"));
    }

    private static String clean(String s) {
        return s.replaceAll("\\(.*\\)", "").replaceAll("\\[.*\\]", "").replaceAll("(?i)^et\\.? al(\\.|\\s)*$", "").replaceAll("(?i)\\s*et\\.? al(\\.|\\s)*$", "").replaceAll("\\d|\\*", "").replaceAll("^(\\s|\\-|\\.)+", "").replaceAll("\\,", "").replaceAll("\\.", ". ").trim();
    }

    public static String cleanDoi(String doi) {
        if (StringUtils.isBlank((CharSequence)doi)) {
            return "";
        }
        String x = doi.replaceAll("\\?", "").replaceAll("\\s*\\/\\s*", "/").replaceAll("\\s*\\-\\s*", "-").trim().replaceAll("\\s", "_").toLowerCase();
        if (!x.equals(doi)) {
            log.info((Object)("Cleaning doi: " + doi + " -> " + x));
        }
        return x;
    }

    public static String capitalize(String s) {
        return Arrays.stream(XsltFunctions.fixApostrophes(s.toLowerCase()).split(" ")).map(p -> Arrays.stream(p.split("-")).map(StringUtils::capitalize).collect(Collectors.joining("-"))).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String fixApostrophes(String s) {
        return s.replaceAll("'a", "'A").replaceAll("'e", "'E").replaceAll("'i", "'I").replaceAll("'o", "'O").replaceAll("'u", "'U").replaceAll("a'", "\u00e0").replaceAll("e'", "\u00e8").replaceAll("i'", "\u00ec").replaceAll("o'", "\u00f2").replaceAll("u'", "\u00f9");
    }

    public static boolean isValidProject(String id) {
        return Project.isValid(id);
    }

    public static String projectLongId(String funder, String program, String code, String jurisdiction, String name, String acronym) {
        return String.format("info:eu-repo/grantAgreement/%s/%s/%s/%s/%s/%s", funder.replaceAll("/", "%2F"), program.replaceAll("/", "%2F"), code.replaceAll("/", "%2F"), jurisdiction.replaceAll("/", "%2F"), name.replaceAll("/", "%2F"), acronym.replaceAll("/", "%2F"));
    }

    public static String calculatePersonName(String s) {
        Pattern pattern = Pattern.compile("info:cnr-pdr\\/author\\/(.+):(.+)\\/(.+)\\/(.+)");
        Matcher matcher = pattern.matcher(s);
        return matcher.find() ? XsltFunctions.capitalize(String.format("%s, %s", matcher.group(3), matcher.group(4))) : "";
    }

    public static String serverName(String s) {
        try {
            return new URL(s).getHost();
        }
        catch (MalformedURLException e) {
            return "Unknown";
        }
    }

    public static String md5(String s) {
        return DigestUtils.md5Hex((String)s);
    }
}

