package eu.dnetlib.data.mdstore.plugins;

import java.io.StringReader;
import java.util.Map;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;

import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecordConvertUtils;
import eu.dnetlib.rmi.data.MDStoreServiceException;

public abstract class MdRecordPlugin extends AbstractIstiMDStorePlugin {

	private static final Log log = LogFactory.getLog(MdRecordPlugin.class);

	@Override
	public final synchronized void process(final MongoMDStore store, final Map<String, String> params) throws MDStoreServiceException {

		final MongoCollection<DBObject> collPubs = store.getCollection();

		int count = 0;

		final SAXReader reader = new SAXReader();

		log.debug("Reconfiguting plugin...");
		reconfigure(params);
		log.info("Plugin reconfigutation completed.");

		for (final DBObject obj : collPubs.find()) {

			try {
				final String recordId = obj.get("id").toString();
				final Document doc = reader.read(new StringReader(obj.get("body").toString()));
				final Element mdNode = (Element) doc.selectSingleNode("//*[local-name() = 'metadata']");
				final Element xmlRecord = (Element) mdNode.selectSingleNode("./record").detach();
				final MdRecord record = MdRecordConvertUtils.fromString(xmlRecord.asXML());

				if (updateRecord(recordId, record)) {
					final Document docPart = reader.read(new StringReader(MdRecordConvertUtils.toString(record)));
					mdNode.add(docPart.getRootElement());
					collPubs.updateOne(new BasicDBObject("id", recordId), new BasicDBObject("$set", new BasicDBObject("body", doc.asXML())));
					count++;
				}

			} catch (final Throwable e) {
				log.warn("Problem parsing a mdstore record", e);
				log.warn(ExceptionUtils.getStackTrace(e));
			}
		}

		log.info("Number of patched records: " + count);

		resetConfiguration();

		touch(store);
	}

	abstract protected void reconfigure(Map<String, String> params);

	abstract protected void resetConfiguration();

	abstract protected boolean updateRecord(String recordId, MdRecord record);

}
