/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.action.FailedCallback;
import eu.dnetlib.data.mdstore.modular.action.MDStorePlugin;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MDStoreDaoImpl;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractIstiMDStorePlugin
implements MDStorePlugin {
    private MDStoreDaoImpl dao;
    @Autowired
    private MDStoreFeeder feeder;
    private static final Log log = LogFactory.getLog(AbstractIstiMDStorePlugin.class);

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public final void run(MDStoreDao dao, Map<String, String> params, DoneCallback doneCallback, FailedCallback failedCallback) {
        if (dao instanceof MDStoreDaoImpl) {
            this.setDao((MDStoreDaoImpl)dao);
        } else {
            log.error((Object)"a mongo mdStore service is required");
            failedCallback.call((Throwable)new MDStoreServiceException("a mongo mdStore service is required"));
        }
        LocalDateTime start = LocalDateTime.now();
        try {
            this.process(this.resolveStore(params, "mdId"), params);
            log.info((Object)("Plugin Execution Time: " + ChronoUnit.SECONDS.between(start, LocalDateTime.now())));
            doneCallback.call(params);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            failedCallback.call(e);
        }
    }

    protected abstract void process(MongoMDStore var1, Map<String, String> var2) throws MDStoreServiceException;

    protected MongoMDStore resolveStore(Map<String, String> params, String key) throws MDStoreServiceException {
        String mdId = params.get(key);
        if (StringUtils.isBlank((CharSequence)mdId)) {
            throw new MDStoreServiceException("mdID is empty");
        }
        MDStore store = this.dao.getMDStore(mdId);
        if (store == null) {
            log.error((Object)("mdStore not found, id: " + mdId));
            throw new MDStoreServiceException("mdStore not found, id: " + mdId);
        }
        if (store instanceof MongoMDStore) {
            return (MongoMDStore)store;
        }
        log.error((Object)"a mongo mdStore is required");
        throw new MDStoreServiceException("a mongo mdStore is required");
    }

    protected void touch(MongoMDStore store) throws MDStoreServiceException {
        this.feeder.touch(store.getId(), this.dao.refreshSize(store.getId()));
    }

    public MDStoreDaoImpl getDao() {
        return this.dao;
    }

    public void setDao(MDStoreDaoImpl dao) {
        this.dao = dao;
    }
}

