/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.plugins;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.plugins.AbstractIstiMDStorePlugin;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecordConvertUtils;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class MdRecordPlugin
extends AbstractIstiMDStorePlugin {
    private static final Log log = LogFactory.getLog(MdRecordPlugin.class);

    @Override
    public final synchronized void process(MongoMDStore store, Map<String, String> params) throws MDStoreServiceException {
        MongoCollection collPubs = store.getCollection();
        int count = 0;
        SAXReader reader = new SAXReader();
        log.debug((Object)"Reconfiguting plugin...");
        this.reconfigure(params);
        log.info((Object)"Plugin reconfigutation completed.");
        for (DBObject obj : collPubs.find()) {
            try {
                Document doc;
                Element mdNode;
                Element xmlRecord;
                MdRecord record;
                String recordId = obj.get("id").toString();
                if (!this.updateRecord(recordId, record = MdRecordConvertUtils.fromString((xmlRecord = (Element)(mdNode = (Element)(doc = reader.read((Reader)new StringReader(obj.get("body").toString()))).selectSingleNode("//*[local-name() = 'metadata']")).selectSingleNode("./record").detach()).asXML()))) continue;
                Document docPart = reader.read((Reader)new StringReader(MdRecordConvertUtils.toString(record)));
                mdNode.add(docPart.getRootElement());
                collPubs.updateOne((Bson)new BasicDBObject("id", (Object)recordId), (Bson)new BasicDBObject("$set", (Object)new BasicDBObject("body", (Object)doc.asXML())));
                ++count;
            }
            catch (Throwable e) {
                log.warn((Object)"Problem parsing a mdstore record", e);
                log.warn((Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        log.info((Object)("Number of patched records: " + count));
        this.resetConfiguration();
        this.touch(store);
    }

    protected abstract void reconfigure(Map<String, String> var1);

    protected abstract void resetConfiguration();

    protected abstract boolean updateRecord(String var1, MdRecord var2);
}

