<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>aggregator</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
				<PARAM name="transformationRuleId"  description="Transformation Rule Identifier"  required="true" managedBy="user" type="string" category="TRANSFORMATION_RULE_ID" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')"/>
				<PARAM name="finalIndexInterpretation" description="Final Index Interpretation"   required="true" managedBy="user" type="string" />
				<PARAM name="finalMongoCollection"  description="Final Mongo Collection"          required="true" managedBy="user" type="string" />
				<PARAM name="collMdstoreId"         description="Store for collected records"     required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="cleanMdstoreId"        description="Store for transformed records"   required="true" managedBy="system" category="MDSTORE_ID"/>
				<PARAM name="hostedBy"              description="Local Repository - label"        required="true" managedBy="user" type="string"/>
				<PARAM name="baseUrl"               description="Local Repository - baseUrl"      required="true" managedBy="user" type="string"/>
				<PARAM name="ftpServer"             description="Local Repository - FTP server"   required="true" managedBy="user" type="string"/>
				<PARAM name="ftpUser"               description="Local Repository - FTP user"     required="true" managedBy="user" type="string"/>
				<PARAM name="ftpPassword"           description="Local Repository - FTP password" required="true" managedBy="user" type="string"/>
				<PARAM name="ftpBaseDir"            description="Local Repository - FTP basedir"  required="true" managedBy="user" type="string"/>
				<PARAM name="ftpSecure"             description="Local Repository - FTP secure"   required="true" managedBy="user" type="boolean"/>
				<PARAM name="OAIDBName"             description="OAI exporter - Mongo Database"   required="true" managedBy="user" type="string"/>
            </PARAMETERS>
            <WORKFLOW>
                <NODE isStart="true" name="collection" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Collect records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="2c8e722e-c095-4e2c-a45d-a6ff75bf0cc9_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"          value="$dsId$" />
 								<ENTRY key="interface"     value="$interface$" />
	 							<ENTRY key="collMdstoreId" ref="collMdstoreId" />
                    		</MAP>
                    	</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="transform"/>
                    </ARCS>
                </NODE>

                <NODE name="transform" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Clean record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="dcd92f5b-9033-46c7-aa7c-2dd367be672b_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"            value="$dsId$" />
                                <ENTRY key="interface"       value="$interface$" />
                                <ENTRY key="collMdstoreId"   ref="collMdstoreId" />
                                <ENTRY key="cleanMdstoreId"  ref="cleanMdstoreId" />
                                <ENTRY key="transformRuleId" ref="transformationRuleId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichCollections"/>
                    </ARCS>
                </NODE>
                
                <NODE name="enrichCollections" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich with collections using OAI sets</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="f0ffb1b2-1518-4087-aa6d-046f507a50ca_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"         ref="cleanMdstoreId" />
                                <ENTRY key="dsId"         value="$dsId$" />
                                <ENTRY key="dsInterface"  value="$interface$" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichLabs"/>
                    </ARCS>
                </NODE>
                
                <NODE name="enrichLabs" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich with labs</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="0e60a6f2-6481-4d8e-a204-b07f862487f2_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"  ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichLocalLinks"/>
                    </ARCS>
                </NODE>
                
                <NODE name="enrichLocalLinks" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich with labs</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="a9a82de0-de9d-4090-8647-fd627ec6481d_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"        ref="cleanMdstoreId" />
                                <ENTRY key="hostedBy"    ref="hostedBy" />
								<ENTRY key="baseUrl"     ref="baseUrl" />
								<ENTRY key="ftpServer"   ref="ftpServer" />
								<ENTRY key="ftpUser"     ref="ftpUser" />
								<ENTRY key="ftpPassword" ref="ftpPassword" />
								<ENTRY key="ftpBaseDir"  ref="ftpBaseDir" />
								<ENTRY key="ftpSecure"   ref="ftpSecure" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichProjects"/>
                    </ARCS>
                </NODE>
                
                <NODE name="enrichProjects" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich with projects using OPENAIRE</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="1089b2e5-05bd-4853-859b-a000780af7e6_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"  ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oai"/>
                    </ARCS>
                </NODE>
                
                <NODE name="oai" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Send to OAI-PMH Publisher</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="4781ebbb-614c-4238-be9e-cbb469861597_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ=="/>
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="cleanMdstoreId" ref="cleanMdstoreId"/>
                                <ENTRY key="OAIFormat" value="native"/>
                                <ENTRY key="OAILayout" value="oai"/>
                                <ENTRY key="OAIInterpretation" value="final"/>
                                <ENTRY key="OAIDBName" ref="OAIDBName"/>
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichOpenaire"/>
                    </ARCS>
                </NODE>
                                
                <NODE name="enrichOpenaire" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich record using OPENAIRE</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="e931594b-12b6-44ee-bb01-f44a6d000594_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"  ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="enrichDatasets"/>
                    </ARCS>
                </NODE>

                <NODE name="enrichDatasets" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Enrich with labs</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="caa89650-edfd-40ab-869a-b0fa62d6f0cb_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"  ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="index"/>
                    </ARCS>
                </NODE>
                
                <NODE name="index" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Index records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="d24261dd-0a5d-4a66-8ca9-c0b8f5a790d1_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="mdId"  ref="cleanMdstoreId" />
                                <ENTRY key="indexFormat" value="PMF"/>
                                <ENTRY key="indexLayout" value="index"/>
                                <ENTRY key="indexInterpretation" ref="finalIndexInterpretation"/>
				<ENTRY key="finalMongoCollection" ref="finalMongoCollection"/>
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
                
                
            </WORKFLOW>
            <DESTROY_WORKFLOW_TEMPLATE id="1de73b0e-ccbf-442c-a88d-41b27daa0ba2_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
            	<PARAMETERS>
	            	<PARAM name="dsId"              value="$dsId$" />
					<PARAM name="interface"         value="$interface$" />
					<PARAM name="collMdstoreId"     ref="collMdstoreId" />
					<PARAM name="cleanMdstoreId"    ref="cleanMdstoreId" />
					<PARAM name="OAIFormat"         value="native"/>
                    <PARAM name="OAILayout"         value="oai"/>
                    <PARAM name="OAIInterpretation" value="final"/>
                    <PARAM name="OAIDBName"         ref="OAIDBName"/>
				</PARAMETERS>
            </DESTROY_WORKFLOW_TEMPLATE>
        </CONFIGURATION>

        <NOTIFICATIONS/>

        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
