package eu.dnetlib.data.mdstore.plugins.objects;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class MdRecordConvertUtils {

	private static JAXBContext jaxbContext;
	private static Marshaller marshaller;
	private static Unmarshaller unmarshaller;

	public synchronized static MdRecord fromString(final String s) throws JAXBException {
		verifyInit();
		return (MdRecord) unmarshaller.unmarshal(new StringReader(s));

	}

	public synchronized static String toString(final MdRecord obj) throws JAXBException {
		final StringWriter sw = new StringWriter();
		marshaller.marshal(obj, sw);
		return sw.toString();
	}

	private static void verifyInit() throws JAXBException {
		if (jaxbContext == null) {
			jaxbContext = JAXBContext.newInstance(MdRecord.class);

			marshaller = jaxbContext.createMarshaller();
			unmarshaller = jaxbContext.createUnmarshaller();

			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		}
	}
}
