/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utils;

import eu.dnetlib.data.mdstore.plugins.objects.Author;
import eu.dnetlib.data.mdstore.plugins.objects.MdRecord;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CsvConverter {
    public static String asCsv(MdRecord record) {
        StringWriter sw = new StringWriter();
        sw.append(CsvConverter.prepareValue(record.getId()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getTitle()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getCreators()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getPublisher()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getType()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue("" + record.getDate()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getDois()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getSource()));
        sw.append("\t");
        sw.append(CsvConverter.prepareValue(record.getDocumentPage()));
        return sw.toString();
    }

    private static CharSequence prepareValue(Set<Author> list) {
        return list.stream().map(Author::getName).map(CsvConverter::prepareValue).filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
    }

    private static String prepareValue(Collection<String> list) {
        return list.stream().map(CsvConverter::prepareValue).filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
    }

    private static String prepareValue(String s) {
        return s == null ? "" : s.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s+", " ").replaceAll("\\p{C}", "?").trim();
    }
}

